package cn.smarthse.modules.health.entity.base.material;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Table(name = "pmc_material_ehs")
public class PmcMaterialEhs implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 企业物料信息id
     */
    @Column(name = "company_material_id")
    private Long companyMaterialId;

    /**
     * 包装类别(枚举)
     */
    @Column(name = "wrapper_type")
    private Byte wrapperType;

    /**
     * 安全技术说明书
     */
    @Column(name = "safety_file_id")
    private String safetyFileId;

    /**
     * 安全标签
     */
    @Column(name = "sectag_file_id")
    private String sectagFileId;

    /**
     * 产品检验报告
     */
    @Column(name = "partners_file_id")
    private String partnersFileId;

    /**
     * 其他附件
     */
    @Column(name = "other_file_id")
    private String otherFileId;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 1-正常,0-已删除
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    

    private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取企业物料信息id
     *
     * @return company_material_id - 企业物料信息id
     */
    public Long getCompanyMaterialId() {
        return companyMaterialId;
    }

    /**
     * 设置企业物料信息id
     *
     * @param companyMaterialId 企业物料信息id
     */
    public void setCompanyMaterialId(Long companyMaterialId) {
        this.companyMaterialId = companyMaterialId;
    }

    /**
     * 获取包装类别(枚举)
     *
     * @return wrapper_type - 包装类别(枚举)
     */
    public Byte getWrapperType() {
        return wrapperType;
    }

    /**
     * 设置包装类别(枚举)
     *
     * @param wrapperType 包装类别(枚举)
     */
    public void setWrapperType(Byte wrapperType) {
        this.wrapperType = wrapperType;
    }

    /**
     * 获取安全技术说明书
     *
     * @return safety_file_id - 安全技术说明书
     */
    public String getSafetyFileId() {
        return safetyFileId;
    }

    /**
     * 设置安全技术说明书
     *
     * @param safetyFileId 安全技术说明书
     */
    public void setSafetyFileId(String safetyFileId) {
        this.safetyFileId = safetyFileId;
    }

    /**
     * 获取安全标签
     *
     * @return sectag_file_id - 安全标签
     */
    public String getSectagFileId() {
        return sectagFileId;
    }

    /**
     * 设置安全标签
     *
     * @param sectagFileId 安全标签
     */
    public void setSectagFileId(String sectagFileId) {
        this.sectagFileId = sectagFileId;
    }

    /**
     * 获取产品检验报告
     *
     * @return partners_file_id - 产品检验报告
     */
    public String getPartnersFileId() {
        return partnersFileId;
    }

    /**
     * 设置产品检验报告
     *
     * @param partnersFileId 产品检验报告
     */
    public void setPartnersFileId(String partnersFileId) {
        this.partnersFileId = partnersFileId;
    }

    /**
     * 获取其他附件
     *
     * @return other_file_id - 其他附件
     */
    public String getOtherFileId() {
        return otherFileId;
    }

    /**
     * 设置其他附件
     *
     * @param otherFileId 其他附件
     */
    public void setOtherFileId(String otherFileId) {
        this.otherFileId = otherFileId;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人
     *
     * @return update_by - 最后修改人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人
     *
     * @param updateBy 最后修改人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取1-正常,0-已删除
     *
     * @return is_valid - 1-正常,0-已删除
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置1-正常,0-已删除
     *
     * @param isValid 1-正常,0-已删除
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}