package cn.smarthse.modules.health.entity.base.material;

import cn.smarthse.modules.health.enums.material.MaterialTypeEnum;
import cn.smarthse.modules.health.enums.material.ShapeStateEnum;
import cn.smarthse.modules.health.enums.material.UnitOfMeasurementEnum;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Table(name = "pmc_company_material")
public class PmcCompanyMaterial implements Serializable {

    private static final long serialVersionUID = 2382787032275313562L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 产品物料ID
     */
    @Column(name = "material_id")
    private Long materialId;

    /**
     * 物料类别
     * <p>
     * raw("原料",1),
     * Accessories("辅料",2),
     * intermediateProducts("中间产品",3),
     * product("产品",4),
     * ByProduct("副产品",5),
     * <p>
     * v3.1.6.1 之前如上。
     * <p>
     * V3.1.6.1 简化版———如下.
     * <p>
     * raw("原料",1),
     * Accessories("辅料",2),
     * product("产品",4),
     */
    @Column(name = "material_type")
    private String materialType;

    /**
     * 物料名称
     */
    @Column(name = "material_name")
    private String materialName;

    /**
     * 中文别名
     */
    @Column(name = "material_nick")
    private String materialNick;

    /**
     * 英文名称
     */
    @Column(name = "material_ename")
    private String materialEname;

    /**
     * CAS号
     */
    @Column(name = "CAS_no")
    private String casNo;

    /**
     * 规格
     */
    private String specification;

    /**
     * 物料状态(枚举 1.气态 2.固态 3.液态 4.其他)
     */
    @Column(name = "material_state")
    private Byte materialState;

    /**
     * 计量单位(枚举
     * 1.万吨 2.吨 3.千克 4.克 5.毫克
     * 6.千米 7.米 8.分米9.厘米 10.毫米
     * 11.平方千米 12.平方米 13.平方厘米
     * 14.万立方米 15.立方米16.升
     * 17.个 18.件19.套 20.瓶 21.桶 22.盒 23.箱 24.台}
     */
    @Column(name = "material_unit")
    private Byte materialUnit;

    /**
     * 是否危险化学品
     */
    @Column(name = "is_hazard")
    private Boolean isHazard;

    /**
     * 是否产生职业病危害因素
     */
    @Column(name = "is_harm")
    private Boolean isHarm;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 1-正常,0-已删除
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    //导入的使用总量
    @Column(name = "material_use_amount")
    private BigDecimal materialUseAmount;
    //导入的存储总量
    @Column(name = "material_store_amount")
    private BigDecimal materialStoreAmount;

    /**
     * 年产量/年用量
     */
    @Column(name = "consumption_or_output")
    private BigDecimal consumptionOrOutput;

    /**
     * 数据所属年份
     */
    @Column(name = "data_year")
    private Integer dataYear;

    //物料类别名称
    @Transient
    private String materialtypeName;

    //物料形态名称
    @Transient
    private String materialstateName;

    //计量单位名称
    @Transient
    private String materialunitName;

    //职业病危害因素ids
    @Transient
    private String harmNames;

    public String getHarmNames() {
        return harmNames;
    }

    public void setHarmNames(String harmNames) {
        this.harmNames = harmNames;
    }

    private void setMaterialtypeName() {
        this.materialtypeName = MaterialTypeEnum.getName(Integer.valueOf(this.materialType));
    }

    /**
     * @return materialtypeName
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-6-19-上午9:12:28
     */
    public String getMaterialtypeName() {
        this.setMaterialtypeName();
        return this.materialtypeName;
    }

    private void setMaterialstateName() {
        if (this.materialState != null) {
            this.materialstateName = ShapeStateEnum.getName(Integer.valueOf(this.materialState));
        }
    }

    /**
     * @return materialstateName
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-6-19-上午9:12:18
     */
    public String getMaterialstateName() {
        this.setMaterialstateName();
        return this.materialstateName;
    }

    private void setMaterialunitName() {
        if (this.materialUnit != null) {
            this.materialunitName = UnitOfMeasurementEnum.getName(Integer.valueOf(this.materialUnit));
        } else {
            this.materialunitName = null;
        }
    }

    /**
     * @return materialunitName
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-6-19-上午9:12:05
     */
    public String getMaterialunitName() {
        this.setMaterialunitName();
        return this.materialunitName;
    }

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取产品物料ID
     *
     * @return material_id - 产品物料ID
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 设置产品物料ID
     *
     * @param materialId 产品物料ID
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    /**
     * 获取物料类别
     *
     * @return material_type - 物料类别
     */
    public String getMaterialType() {
        return materialType;
    }

    /**
     * 设置物料类别
     *
     * @param materialType 物料类别
     */
    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    /**
     * 获取物料名称
     *
     * @return material_name - 物料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 设置物料名称
     *
     * @param materialName 物料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName == null ? null : materialName.trim();
    }

    /**
     * 获取中文别名
     *
     * @return material_nick - 中文别名
     */
    public String getMaterialNick() {
        return materialNick;
    }

    /**
     * 设置中文别名
     *
     * @param materialNick 中文别名
     */
    public void setMaterialNick(String materialNick) {
        this.materialNick = materialNick == null ? null : materialNick.trim();
    }

    /**
     * 获取英文名称
     *
     * @return material_ename - 英文名称
     */
    public String getMaterialEname() {
        return materialEname;
    }

    /**
     * 设置英文名称
     *
     * @param materialEname 英文名称
     */
    public void setMaterialEname(String materialEname) {
        this.materialEname = materialEname == null ? null : materialEname.trim();
    }

    /**
     * 获取CAS号
     *
     * @return CAS_no - CAS号
     */
    public String getCasNo() {
        return casNo;
    }

    /**
     * 设置CAS号
     *
     * @param casNo CAS号
     */
    public void setCasNo(String casNo) {
        this.casNo = casNo == null ? null : casNo.trim();
    }

    /**
     * 获取规格
     *
     * @return specification - 规格
     */
    public String getSpecification() {
        return specification;
    }

    /**
     * 设置规格
     *
     * @param specification 规格
     */
    public void setSpecification(String specification) {
        this.specification = specification == null ? null : specification.trim();
    }

    /**
     * 获取物料状态(枚举 1.气态 2.固态 3.液态 4.其他)
     *
     * @return material_state - 物料状态(枚举 1.气态 2.固态 3.液态 4.其他)
     */
    public Byte getMaterialState() {
        return materialState;
    }

    /**
     * 设置物料状态(枚举 1.气态 2.固态 3.液态 4.其他)
     *
     * @param materialState 物料状态(枚举 1.气态 2.固态 3.液态 4.其他)
     */
    public void setMaterialState(Byte materialState) {
        this.materialState = materialState;
    }

    /**
     * 获取计量单位(枚举
     * 1.万吨 2.吨 3.千克 4.克 5.毫克
     * 6.千米 7.米 8.分米9.厘米 10.毫米
     * 11.平方千米 12.平方米 13.平方厘米
     * 14.万立方米 15.立方米16.升
     * 17.个 18.件19.套 20.瓶 21.桶 22.盒 23.箱 24.台}
     *
     * @return material_unit - 计量单位(枚举
     * 1.万吨 2.吨 3.千克 4.克 5.毫克
     * 6.千米 7.米 8.分米9.厘米 10.毫米
     * 11.平方千米 12.平方米 13.平方厘米
     * 14.万立方米 15.立方米16.升
     * 17.个 18.件19.套 20.瓶 21.桶 22.盒 23.箱 24.台}
     */
    public Byte getMaterialUnit() {
        return materialUnit;
    }

    /**
     * 设置计量单位(枚举
     * 1.万吨 2.吨 3.千克 4.克 5.毫克
     * 6.千米 7.米 8.分米9.厘米 10.毫米
     * 11.平方千米 12.平方米 13.平方厘米
     * 14.万立方米 15.立方米16.升
     * 17.个 18.件19.套 20.瓶 21.桶 22.盒 23.箱 24.台}
     *
     * @param materialUnit 计量单位(枚举
     *                     1.万吨 2.吨 3.千克 4.克 5.毫克
     *                     6.千米 7.米 8.分米9.厘米 10.毫米
     *                     11.平方千米 12.平方米 13.平方厘米
     *                     14.万立方米 15.立方米16.升
     *                     17.个 18.件19.套 20.瓶 21.桶 22.盒 23.箱 24.台}
     */
    public void setMaterialUnit(Byte materialUnit) {
        this.materialUnit = materialUnit;
    }

    /**
     * 是否产生职业病危害因素
     *
     * @return is_harm - 是否产生职业病危害因素
     */
    public Boolean getIsHarm() {
        return isHarm;
    }

    /**
     * 是否产生职业病危害因素
     *
     * @param isHarm 是否产生职业病危害因素
     */
    public void setIsHarm(Boolean isHarm) {
        this.isHarm = isHarm;
    }

    /**
     * 获取是否产生职业病危害因素
     *
     * @return is_hazard - 是否产生职业病危害因素
     */
    public Boolean getIsHazard() {
        return isHazard;
    }

    /**
     * 设置是否危险化学品
     *
     * @param isHazard 是否危险化学品
     */
    public void setIsHazard(Boolean isHazard) {
        this.isHazard = isHazard;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改人
     *
     * @return update_by - 最后修改人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人
     *
     * @param updateBy 最后修改人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取1-正常,0-已删除
     *
     * @return is_valid - 1-正常,0-已删除
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置1-正常,0-已删除
     *
     * @param isValid 1-正常,0-已删除
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public BigDecimal getMaterialUseAmount() {
        return materialUseAmount;
    }

    public void setMaterialUseAmount(BigDecimal materialUseAmount) {
        this.materialUseAmount = materialUseAmount;
    }

    public BigDecimal getMaterialStoreAmount() {
        return materialStoreAmount;
    }

    public void setMaterialStoreAmount(BigDecimal materialStoreAmount) {
        this.materialStoreAmount = materialStoreAmount;
    }

    public BigDecimal getConsumptionOrOutput() {
        return consumptionOrOutput;
    }

    public void setConsumptionOrOutput(BigDecimal consumptionOrOutput) {
        this.consumptionOrOutput = consumptionOrOutput;
    }

    public Boolean getHazard() {
        return isHazard;
    }

    public void setHazard(Boolean hazard) {
        isHazard = hazard;
    }

    public Boolean getHarm() {
        return isHarm;
    }

    public void setHarm(Boolean harm) {
        isHarm = harm;
    }

    public void setMaterialtypeName(String materialtypeName) {
        this.materialtypeName = materialtypeName;
    }

    public void setMaterialstateName(String materialstateName) {
        this.materialstateName = materialstateName;
    }

    public void setMaterialunitName(String materialunitName) {
        this.materialunitName = materialunitName;
    }

    public Integer getDataYear() {
        return dataYear;
    }

    public void setDataYear(Integer dataYear) {
        this.dataYear = dataYear;
    }
}