package cn.smarthse.modules.health.entity.base.device;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "device_type")
public class DeviceType implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 设备分类代码
     */
    @Column(name = "type_code")
    private String typeCode;

    /**
     * 分类名称
     */
    @Column(name = "type_name")
    private String typeName;

    /**
     * 拼音
     */
    private String pinyin;

    /**
     * 级别
     */
    @Column(name = "type_level")
    private String typeLevel;

    /**
     * 说明
     */
    private String description;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 是否正常(1-正常,0-删除)
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 父级
     */
    private Long pid;

    /**
     * 创建人staffID
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 修改人staffID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 组织机构编码，完整的表示该组织的上下级关系
     */
    @Column(name = "orgCode")
    private String orgcode;

    private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取设备分类代码
     *
     * @return type_code - 设备分类代码
     */
    public String getTypeCode() {
        return typeCode;
    }

    /**
     * 设置设备分类代码
     *
     * @param typeCode 设备分类代码
     */
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode == null ? null : typeCode.trim();
    }

    /**
     * 获取分类名称
     *
     * @return type_name - 分类名称
     */
    public String getTypeName() {
        return typeName;
    }

    /**
     * 设置分类名称
     *
     * @param typeName 分类名称
     */
    public void setTypeName(String typeName) {
        this.typeName = typeName == null ? null : typeName.trim();
    }

    /**
     * 获取拼音
     *
     * @return pinyin - 拼音
     */
    public String getPinyin() {
        return pinyin;
    }

    /**
     * 设置拼音
     *
     * @param pinyin 拼音
     */
    public void setPinyin(String pinyin) {
        this.pinyin = pinyin == null ? null : pinyin.trim();
    }

    /**
     * 获取级别
     *
     * @return type_level - 级别
     */
    public String getTypeLevel() {
        return typeLevel;
    }

    /**
     * 设置级别
     *
     * @param typeLevel 级别
     */
    public void setTypeLevel(String typeLevel) {
        this.typeLevel = typeLevel == null ? null : typeLevel.trim();
    }

    /**
     * 获取说明
     *
     * @return description - 说明
     */
    public String getDescription() {
        return description;
    }

    /**
     * 设置说明
     *
     * @param description 说明
     */
    public void setDescription(String description) {
        this.description = description == null ? null : description.trim();
    }

    /**
     * 获取企业id
     *
     * @return cid - 企业id
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业id
     *
     * @param cid 企业id
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取是否正常(1-正常,0-删除)
     *
     * @return is_valid - 是否正常(1-正常,0-删除)
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否正常(1-正常,0-删除)
     *
     * @param isValid 是否正常(1-正常,0-删除)
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取父级
     *
     * @return pid - 父级
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 设置父级
     *
     * @param pid 父级
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }

    /**
     * 获取创建人staffID
     *
     * @return create_by - 创建人staffID
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人staffID
     *
     * @param createBy 创建人staffID
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取修改人staffID
     *
     * @return update_by - 修改人staffID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置修改人staffID
     *
     * @param updateBy 修改人staffID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取修改时间
     *
     * @return update_data - 修改时间
     */
    public Date getUpdateData() {
        return updateDate;
    }

    /**
     * 设置修改时间
     *
     * @param updateData 修改时间
     */
    public void setUpdateData(Date updateData) {
        this.updateDate = updateData;
    }

    /**
     * 获取组织机构编码，完整的表示该组织的上下级关系
     *
     * @return orgCode - 组织机构编码，完整的表示该组织的上下级关系
     */
    public String getOrgcode() {
        return orgcode;
    }

    /**
     * 设置组织机构编码，完整的表示该组织的上下级关系
     *
     * @param orgcode 组织机构编码，完整的表示该组织的上下级关系
     */
    public void setOrgcode(String orgcode) {
        this.orgcode = orgcode == null ? null : orgcode.trim();
    }
}