package cn.smarthse.modules.health.entity.base.device;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "device_special")
public class DeviceSpecial implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 设备编号
     */
    @Column(name = "device_id")
    private Long deviceId;

    /**
     * 特种设备类型
     */
    @Column(name = "special_type_id")
    private Long specialTypeId;

    /**
     * 放射设备类型
     */
    @Column(name = "radiation_type")
    private Long radiationType;

    /**
     * 射线装置类型
     */
    @Column(name = "radiation_raytype")
    private Long radiationRaytype;

    /**
     * 射线装置源强
     */
    @Column(name = "radiation_source_strength")
    private String radiationSourceStrength;

    /**
     * 核素名称
     */
    @Column(name = "species_name")
    private String speciesName;

    /**
     * 放射源类型
     */
    @Column(name = "species_soure_type")
    private String speciesSoureType;

    /**
     * 放射源强
     */
    @Column(name = "species_soure_strength")
    private String speciesSoureStrength;

    /**
     * 居里/贝克
     */
    @Column(name = "species_soure_strength_unit")
    private String speciesSoureStrengthUnit;

    /**
     * 放射源生产日期
     */
    @Column(name = "species_produced_time")
    private Date speciesProducedTime;

    /**
     * 是否正常(1-正常,0-删除)
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人staffID
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 修改人staffID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业id
     *
     * @return cid - 企业id
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业id
     *
     * @param cid 企业id
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取设备编号
     *
     * @return device_id - 设备编号
     */
    public Long getDeviceId() {
        return deviceId;
    }

    /**
     * 设置设备编号
     *
     * @param deviceId 设备编号
     */
    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    /**
     * 获取特种设备类型
     *
     * @return special_type_id - 特种设备类型
     */
    public Long getSpecialTypeId() {
        return specialTypeId;
    }

    /**
     * 设置特种设备类型
     *
     * @param specialTypeId 特种设备类型
     */
    public void setSpecialTypeId(Long specialTypeId) {
        this.specialTypeId = specialTypeId;
    }

    /**
     * 获取放射设备类型
     *
     * @return radiation_type - 放射设备类型
     */
    public Long getRadiationType() {
        return radiationType;
    }

    /**
     * 设置放射设备类型
     *
     * @param radiationType 放射设备类型
     */
    public void setRadiationType(Long radiationType) {
        this.radiationType = radiationType;
    }

    /**
     * 获取射线装置类型
     *
     * @return radiation_raytype - 射线装置类型
     */
    public Long getRadiationRaytype() {
        return radiationRaytype;
    }

    /**
     * 设置射线装置类型
     *
     * @param radiationRaytype 射线装置类型
     */
    public void setRadiationRaytype(Long radiationRaytype) {
        this.radiationRaytype = radiationRaytype;
    }

    /**
     * 获取射线装置源强
     *
     * @return radiation_source_strength - 射线装置源强
     */
    public String getRadiationSourceStrength() {
        return radiationSourceStrength;
    }

    /**
     * 设置射线装置源强
     *
     * @param radiationSourceStrength 射线装置源强
     */
    public void setRadiationSourceStrength(String radiationSourceStrength) {
        this.radiationSourceStrength = radiationSourceStrength == null ? null : radiationSourceStrength.trim();
    }

    /**
     * 获取核素名称
     *
     * @return species_name - 核素名称
     */
    public String getSpeciesName() {
        return speciesName;
    }

    /**
     * 设置核素名称
     *
     * @param speciesName 核素名称
     */
    public void setSpeciesName(String speciesName) {
        this.speciesName = speciesName == null ? null : speciesName.trim();
    }

    /**
     * 获取放射源类型
     *
     * @return species_soure_type - 放射源类型
     */
    public String getSpeciesSoureType() {
        return speciesSoureType;
    }

    /**
     * 设置放射源类型
     *
     * @param speciesSoureType 放射源类型
     */
    public void setSpeciesSoureType(String speciesSoureType) {
        this.speciesSoureType = speciesSoureType;
    }

    /**
     * 获取放射源强
     *
     * @return species_soure_strength - 放射源强
     */
    public String getSpeciesSoureStrength() {
        return speciesSoureStrength;
    }

    /**
     * 设置放射源强
     *
     * @param speciesSoureStrength 放射源强
     */
    public void setSpeciesSoureStrength(String speciesSoureStrength) {
        this.speciesSoureStrength = speciesSoureStrength == null ? null : speciesSoureStrength.trim();
    }

    /**
     * 获取居里/贝克
     *
     * @return species_soure_strength_unit - 居里/贝克
     */
    public String getSpeciesSoureStrengthUnit() {
        return speciesSoureStrengthUnit;
    }

    /**
     * 设置居里/贝克
     *
     * @param speciesSoureStrengthUnit 居里/贝克
     */
    public void setSpeciesSoureStrengthUnit(String speciesSoureStrengthUnit) {
        this.speciesSoureStrengthUnit = speciesSoureStrengthUnit == null ? null : speciesSoureStrengthUnit.trim();
    }

    /**
     * 获取放射源生产日期
     *
     * @return species_produced_time - 放射源生产日期
     */
    public Date getSpeciesProducedTime() {
        return speciesProducedTime;
    }

    /**
     * 设置放射源生产日期
     *
     * @param speciesProducedTime 放射源生产日期
     */
    public void setSpeciesProducedTime(Date speciesProducedTime) {
        this.speciesProducedTime = speciesProducedTime;
    }

    /**
     * 获取是否正常(1-正常,0-删除)
     *
     * @return is_valid - 是否正常(1-正常,0-删除)
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否正常(1-正常,0-删除)
     *
     * @param isValid 是否正常(1-正常,0-删除)
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人staffID
     *
     * @return create_by - 创建人staffID
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人staffID
     *
     * @param createBy 创建人staffID
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取修改人staffID
     *
     * @return update_by - 修改人staffID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置修改人staffID
     *
     * @param updateBy 修改人staffID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取修改时间
     *
     * @return update_data - 修改时间
     */
    public Date getUpdateData() {
        return updateDate;
    }

    /**
     * 设置修改时间
     *
     * @param updateData 修改时间
     */
    public void setUpdateData(Date updateData) {
        this.updateDate = updateData;
    }
}