package cn.smarthse.modules.health.entity.base.device;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 待维护设备提醒忽略 （忽略提醒的设备）
 * @since 2019/10/14 0014 14:55
 */
@Table(name = "device_no_maintain_ignore")
public class DeviceNoMaintainIgnore implements Serializable {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 设备id
     */
    private Long deviceId;

    /**
     * 操作员id
     */
    private Long operator;

    /**
     * 创建时间
     */
    private Date createDate;

    private Byte isValid;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public Long getOperator() {
        return operator;
    }

    public void setOperator(Long operator) {
        this.operator = operator;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Byte getIsValid() {
        return isValid;
    }

    public void setIsValid(Byte isValid) {
        this.isValid = isValid;
    }
}
