package cn.smarthse.modules.health.entity.base.device;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

import lombok.Data;

@Table(name = "device_maintenance_fence_view")
public @Data class DeviceMaintenanceFenceView implements Serializable {
	
    /**
     * 设备ID
     */
	@Id
    @Column(name = "device_id")
    private Long deviceId;

    /**
     * 设备名称
     */
    @Column(name = "device_name")
    private String deviceName;

    /**
     * 设备编号
     */
    @Column(name = "device_no")
    private String deviceNo;

    /**
     * 设备型号
     */
    @Column(name = "device_model")
    private String deviceModel;

    /**
     * 组织名称
     */
    @Column(name = "organization_name")
    private String organizationName;

    /**
     * 姓名
     */
    @Column(name = "manager_name")
    private String managerName;

    /**
     * 检修时间
     */
    @Column(name = "mainte_time")
    private Date mainteTime;

    /**
     * 工作名称
     */
    @Column(name = "mainte_reason")
    private String mainteReason;

    /**
     * 文件名称（‘,’隔开）
     */
    @Column(name = "fileNames")
    private String filenames;
    
    /**
     * 企业id
     */
    private Long cid;
    
    /**
     * 文件id（‘,’隔开）
     */
    @Column(name = "fileIds")
    private String fileIds;
    

    private static final long serialVersionUID = 1L;

    /**
     * 获取设备ID
     *
     * @return device_id - 设备ID
     */
    public Long getDeviceId() {
        return deviceId;
    }

    /**
     * 设置设备ID
     *
     * @param deviceId 设备ID
     */
    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    /**
     * 获取设备名称
     *
     * @return device_name - 设备名称
     */
    public String getDeviceName() {
        return deviceName;
    }

    /**
     * 设置设备名称
     *
     * @param deviceName 设备名称
     */
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName == null ? null : deviceName.trim();
    }

    /**
     * 获取设备编号
     *
     * @return device_no - 设备编号
     */
    public String getDeviceNo() {
        return deviceNo;
    }

    /**
     * 设置设备编号
     *
     * @param deviceNo 设备编号
     */
    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo == null ? null : deviceNo.trim();
    }

    /**
     * 获取设备型号
     *
     * @return device_model - 设备型号
     */
    public String getDeviceModel() {
        return deviceModel;
    }

    /**
     * 设置设备型号
     *
     * @param deviceModel 设备型号
     */
    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel == null ? null : deviceModel.trim();
    }

    /**
     * 获取组织名称
     *
     * @return organization_name - 组织名称
     */
    public String getOrganizationName() {
        return organizationName;
    }

    /**
     * 设置组织名称
     *
     * @param organizationName 组织名称
     */
    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName == null ? null : organizationName.trim();
    }

    /**
     * 获取姓名
     *
     * @return manager_name - 姓名
     */
    public String getManagerName() {
        return managerName;
    }

    /**
     * 设置姓名
     *
     * @param managerName 姓名
     */
    public void setManagerName(String managerName) {
        this.managerName = managerName == null ? null : managerName.trim();
    }

    /**
     * 获取检修时间
     *
     * @return mainte_time - 检修时间
     */
    public Date getMainteTime() {
        return mainteTime;
    }

    /**
     * 设置检修时间
     *
     * @param mainteTime 检修时间
     */
    public void setMainteTime(Date mainteTime) {
        this.mainteTime = mainteTime;
    }

    /**
     * 获取工作名称
     *
     * @return mainte_reason - 工作名称
     */
    public String getMainteReason() {
        return mainteReason;
    }

    /**
     * 设置工作名称
     *
     * @param mainteReason 工作名称
     */
    public void setMainteReason(String mainteReason) {
        this.mainteReason = mainteReason == null ? null : mainteReason.trim();
    }

    /**
     * @return fileNames
     */
    public String getFilenames() {
        return filenames;
    }

    /**
     * @param filenames
     */
    public void setFilenames(String filenames) {
        this.filenames = filenames == null ? null : filenames.trim();
    }
}