package cn.smarthse.modules.health.entity.base.device;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "device_maintenance_fence_file")
public class DeviceMaintenanceFenceFile implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 维护的防护设备信息id
     */
    @Column(name = "device_maintenance_fence_id")
    private Long deviceMaintenanceFenceId;

    /**
     * 图片
     */
    @Column(name = "file_id")
    private Long fileId;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 1-正常,0-已删除
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 维护表ID
     */
    @Column(name = "maintenance_id")
    private Long maintenanceId;

    /**
     * 企业id
     */
    private Long cid;

    private static final long serialVersionUID = 1L;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取维护的防护设备信息id
     *
     * @return device_maintenance_fence_id - 维护的防护设备信息id
     */
    public Long getDeviceMaintenanceFenceId() {
        return deviceMaintenanceFenceId;
    }

    /**
     * 设置维护的防护设备信息id
     *
     * @param deviceMaintenanceFenceId 维护的防护设备信息id
     */
    public void setDeviceMaintenanceFenceId(Long deviceMaintenanceFenceId) {
        this.deviceMaintenanceFenceId = deviceMaintenanceFenceId;
    }

    /**
     * 获取图片
     *
     * @return file_id - 图片
     */
    public Long getFileId() {
        return fileId;
    }

    /**
     * 设置图片
     *
     * @param fileId 图片
     */
    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人
     *
     * @return update_by - 最后修改人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人
     *
     * @param updateBy 最后修改人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_data - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateData 最后修改时间
     */
    public void setUpdateData(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取1-正常,0-已删除
     *
     * @return is_valid - 1-正常,0-已删除
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置1-正常,0-已删除
     *
     * @param isValid 1-正常,0-已删除
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取维护表ID
     *
     * @return maintenance_id - 维护表ID
     */
    public Long getMaintenanceId() {
        return maintenanceId;
    }

    /**
     * 设置维护表ID
     *
     * @param maintenanceId 维护表ID
     */
    public void setMaintenanceId(Long maintenanceId) {
        this.maintenanceId = maintenanceId;
    }

    /**
     * 获取企业id
     *
     * @return cid - 企业id
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业id
     *
     * @param cid 企业id
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }
}