package cn.smarthse.modules.health.entity.base.device;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "device_maintenance_fence")
public class DeviceMaintenanceFence implements Serializable {
    /**
     * id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 设备ID
     */
    @Column(name = "device_id")
    private Long deviceId;

    /**
     * 设备名称
     */
    @Column(name = "device_name")
    private String deviceName;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 1-正常,0-已删除
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 维护表ID
     */
    @Column(name = "maintenance_id")
    private Long maintenanceId;

    /**
     * 防护设备编号
     */
    @Transient
    private String deviceNo;
    
    /**
     * 防护设备型号
     */
    @Transient
    private String deviceModel;
    
    /**
     * 使用车间
     */
    @Transient
    private String useAreaId;
    
    
    /**
     * 使用车间
     */
    @Transient
    private String useareaname;
    
    /**
     * 排序
     */
    @Transient
    private String order;
    
    /**
     * 企业id
     */
    private Long cid;

    /**
     * 负责人
     */
    @Transient
    private String managerName;
    

    private static final long serialVersionUID = 1L;

    
    
    
    public String getDeviceNo() {
		return deviceNo;
	}

	public void setDeviceNo(String deviceNo) {
		this.deviceNo = deviceNo;
	}

	public String getDeviceModel() {
		return deviceModel;
	}

	public void setDeviceModel(String deviceModel) {
		this.deviceModel = deviceModel;
	}

	public String getUseareaname() {
		return useareaname;
	}

	public void setUseareaname(String useareaname) {
		this.useareaname = useareaname;
	}

	public String getOrder() {
		return order;
	}

	public void setOrder(String order) {
		this.order = order;
	}

    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    /**
     * 获取id
     *
     * @return id - id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置id
     *
     * @param id id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取设备ID
     *
     * @return device_id - 设备ID
     */
    public Long getDeviceId() {
        return deviceId;
    }

    /**
     * 设置设备ID
     *
     * @param deviceId 设备ID
     */
    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    /**
     * 获取设备名称
     *
     * @return device_name - 设备名称
     */
    public String getDeviceName() {
        return deviceName;
    }

    /**
     * 设置设备名称
     *
     * @param deviceName 设备名称
     */
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName == null ? null : deviceName.trim();
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人
     *
     * @return update_by - 最后修改人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人
     *
     * @param updateBy 最后修改人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_data - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateData 最后修改时间
     */
    public void setUpdateData(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取1-正常,0-已删除
     *
     * @return is_valid - 1-正常,0-已删除
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置1-正常,0-已删除
     *
     * @param isValid 1-正常,0-已删除
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取维护表ID
     *
     * @return maintenance_id - 维护表ID
     */
    public Long getMaintenanceId() {
        return maintenanceId;
    }

    /**
     * 设置维护表ID
     *
     * @param maintenanceId 维护表ID
     */
    public void setMaintenanceId(Long maintenanceId) {
        this.maintenanceId = maintenanceId;
    }

    /**
     * 获取企业id
     *
     * @return cid - 企业id
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业id
     *
     * @param cid 企业id
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    public String getUseAreaId() {
        return useAreaId;
    }

    public void setUseAreaId(String useAreaId) {
        this.useAreaId = useAreaId;
    }

    public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}



}