package cn.smarthse.modules.health.entity.base.device;

import javax.persistence.*;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

@Table(name = "device_maintenance")
public class DeviceMaintenance implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 工作名称
     */
    @Column(name = "mainte_reason")
    private String mainteReason;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 负责人
     */
    private Long acceptor;

    /**
     * 检修时间
     */
    @Column(name = "mainte_time")
    private Date mainteTime;
    @Transient
    private String mainteTimeStr;

    /**
     * 纸质文件存放地址
     */
    @Column(name = "file_address")
    private String fileAddress;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    
    @Transient
    private String updateDateStr;

    /**
     * 1-正常,0-已删除
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 保存状态(0存草稿1完成)
     */
    @Column(name = "save_state")
    private Boolean saveState;
    
    
    /**
     * 负责人姓名
     */
    @Transient
    private String acceptorName;

    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private String orgId;

    @Transient
    private Integer mainteYear;

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    /**
     * 排序
     */
    @Transient
    private String order;
    
    
    public String getOrder() {
		return order;
	}

	public void setOrder(String order) {
		this.order = order;
	}

	public String getAcceptorName() {
		return acceptorName;
	}

	public void setAcceptorName(String acceptorName) {
		this.acceptorName = acceptorName;
	}

	public Boolean getSaveState() {
		return saveState;
	}

	public void setSaveState(Boolean saveState) {
		this.saveState = saveState;
	}

	private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业id
     *
     * @return cid - 企业id
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业id
     *
     * @param cid 企业id
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取工作名称
     *
     * @return mainte_reason - 工作名称
     */
    public String getMainteReason() {
        return mainteReason;
    }

    /**
     * 设置工作名称
     *
     * @param mainteReason 工作名称
     */
    public void setMainteReason(String mainteReason) {
        this.mainteReason = mainteReason == null ? null : mainteReason.trim();
    }

    /**
     * 获取备注
     *
     * @return mainte_remark - 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注
     *
     * @param mainteRemark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**
     * 获取负责人
     *
     * @return acceptor - 负责人
     */
    public Long getAcceptor() {
        return acceptor;
    }

    /**
     * 设置负责人
     *
     * @param acceptor 负责人
     */
    public void setAcceptor(Long acceptor) {
        this.acceptor = acceptor;
    }

    /**
     * 获取检修时间
     *
     * @return mainte_time - 检修时间
     */
    public Date getMainteTime() {
        return mainteTime;
    }

    /**
     * 设置检修时间
     *
     * @param mainteTime 检修时间
     */
    public void setMainteTime(Date mainteTime) {
        this.mainteTime = mainteTime;
    }

    /**
     * 获取纸质文件存放地址
     *
     * @return file_address - 纸质文件存放地址
     */
    public String getFileAddress() {
        return fileAddress;
    }

    /**
     * 设置纸质文件存放地址
     *
     * @param fileAddress 纸质文件存放地址
     */
    public void setFileAddress(String fileAddress) {
        this.fileAddress = fileAddress == null ? null : fileAddress.trim();
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人
     *
     * @return update_by - 最后修改人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人
     *
     * @param updateBy 最后修改人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_data - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateData 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取1-正常,0-已删除
     *
     * @return is_valid - 1-正常,0-已删除
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置1-正常,0-已删除
     *
     * @param isValid 1-正常,0-已删除
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getMainteTimeStr() {
		if(this.mainteTime!=null){
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			this.mainteTimeStr = sdf.format(this.mainteTime);
		}
		return mainteTimeStr;
	}

	public void setMainteTimeStr(String mainteTimeStr) {
		this.mainteTimeStr = mainteTimeStr;
	}

	public String getUpdateDateStr() {
		if(this.updateDate!=null){
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			this.updateDateStr = sdf.format(this.updateDate);
		}
		return updateDateStr;
	}

	public void setUpdateDateStr(String updateDateStr) {
		this.updateDateStr = updateDateStr;
	}

    public Integer getMainteYear() {
        return mainteYear;
    }

    public void setMainteYear(Integer mainteYear) {
        this.mainteYear = mainteYear;
    }
}