package cn.smarthse.modules.health.entity.base.device;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.enums.device.DeviceStateEnum;
import lombok.Data;

@Table(name = "device_list_view")
public @Data class DeviceListView implements Serializable {
	
    /**
     * ID
     */
	@Id
    private Long id;

    /**
     * 将id转为字符串类型（long类型过长丢失精度）
    */
    @Transient
    private String strId;

    /**
     * 分类编号(Devicetype.id)
     */
    @Column(name = "type_id")
    private Long typeId;

    /**
     * 分类名称
     */
    @Column(name = "type_name")
    private String typeName;

    /**
     * 设备名称
     */
    @Column(name = "device_name")
    private String deviceName;

    /**
     * 设备编号
     */
    @Column(name = "device_no")
    private String deviceNo;

    /**
     * 设备型号
     */
    @Column(name = "device_model")
    private String deviceModel;

    /**
     * 1-正常，2-故障，3-维修，4-报废，5-其他
     */
    @Column(name = "device_state")
    private Byte deviceState;

    /**
     * 车间编号
     */
    @Column(name = "use_area_id")
    private String useAreaId;

    /**
     * 使用车间
     */
    private String useareaname;
    
    /**
     * 安装地点区域名称
     */
    @Column(name = "installAreaName")
    private String installAreaName;
    
    /**
     * 安装地点区域id
     */
    @Column(name = "installAreaId")
    private Long installAreaId;
    
    /**
     * 安装地点区域全路径名称
     */
    @Transient
    private String installAreaFullName;

    /**
     * 安装地点
     */
    @Column(name = "install_position")
    private String installPosition;
    
    @Transient
    private String installInfo;

    /**
     * 生产单位
     */
    private String manufacturer;

    /**
     * 供货单位
     */
    private String supplier;

    /**
     * 安装单位
     */
    private String installer;

    /**
     * 验收时间
     */
    @Column(name = "accept_time")
    private Date acceptTime;

    /**
     * 投用日期
     */
    @Column(name = "use_time")
    private Date useTime;

    /**
     * 负责人(用户编号)
     */
    @Column(name = "managerId")
    private Long managerid;

    /**
     * 是否产生职业病危害因素
     */
    @Column(name = "is_harm")
    private Boolean isHarm;

    /**
     * 是否特种设备
     */
    @Deprecated
    @Column(name = "is_special")
    private Boolean isSpecial;

    /**
     * 是否放射设备
     */
    @Column(name = "is_radiation")
    private Boolean isRadiation;

    /**
     * 是否职业病防护设施
     */
    @Column(name = "is_devicefh")
    private Boolean isDevicefh;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid = true;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 使用岗位
     */
    private String workrolenames;
    
    /**
     * 使用岗位
     */
    @Column(name = "workIds")
    private String workIds;

    /**
     * 使用物料
     */
    private String materials;
    
    /**
     * 负责人姓名
     */
    @Column(name = "manager_name")
    private String managerName;

    /**
     * 出厂日期
     */
    @Column(name = "produced_time")
    private Date producedTime;
    
    /**
     * 防护用途
     */
    @Column(name = "purpose")
    private String purpose;
    
    /**
     * 可能产生的职业病危害因素
     */
    @Column(name = "harmNames")
    private String harmNames;
    
    
    /**
     * 关联的防护设施
     */
    @Deprecated
    @Column(name = "relationNames")
    private String relationNames;
    
    /**
     * 状态名称
     */
    @Transient
    private String deviceStateName;
    
    /**
     * 查询排序
     */
    @Transient
    private String order;
    
    /**
     * 模糊查询关键词
     */
    @Transient
    private String keyword;
    
    
    /**
     * 除了报废
     */
    @Transient
    private String state;
    
    /**
     * 格式化更新时间
     */
    @Transient
    private String upDate;
    
    /**
     * 查询当前年份
     */
    @Transient
    private String endDate;
    
    /**
     * 是否只选择一般生产设备：只选择有职业病危害因素的设备（不包过职业病防护设施类型的，只有一般生产生设备才有危害因素）
     */
    @Transient
    private Boolean onlyCommonly;
    
    @Column(name = "type_pid")
    private Long typePid;
    
    @Transient
    private List<Long> childrenTypeIds;
    
    @Transient
    private List<Long> excludeTypeIds;

    @Transient
    private List<Long> useOrgIds;

    @Transient
    private List<Long> managerIds;

    @Transient
    private List<Long> photoIds;

    public List<Long> getPhotoIds() {
        return photoIds;
    }

    public void setPhotoIds(List<Long> photoIds) {
        this.photoIds = photoIds;
    }

    /**
     * 查询投用年份
     */
    @Transient
    private String useYear;
    /**
     *  设备设施年份
     */
    @Transient
    private String years;
    /**
     *  设备设施档案本年最后更新时间
     */
    @Transient
    private String lastUpdate;
    public Boolean getOnlyCommonly() {
		return onlyCommonly;
	}

	public void setOnlyCommonly(Boolean onlyCommonly) {
		this.onlyCommonly = onlyCommonly;
	}

	public String getUpDate() {
    	this.setUpDate(upDate);
		return upDate;
	}

	public void setUpDate(String upDate) {
		if(this.updateDate != null){
			this.upDate = DateUtils.getDate(updateDate);
		}
		
	}
    /**
     * 报废时间
     */
    @Column(name = "scrap_time")
    private Date scrapTime;

	public String getOrder() {
		return order;
	}

	public void setOrder(String order) {
		this.order = order;
	}

	public String getKeyword() {
		return keyword;
	}

	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}

	public String getPurpose() {
		return purpose;
	}

	public void setPurpose(String purpose) {
		this.purpose = purpose;
	}

	public Date getProducedTime() {
		return producedTime;
	}

	public void setProducedTime(Date producedTime) {
		this.producedTime = producedTime;
	}

	public String getDeviceStateName() {
    	this.setDeviceStateName();
		return deviceStateName;
	}

	public void setDeviceStateName() {
		if(this.getDeviceState() != null && this.getDeviceState() != '0'){
			this.deviceStateName = DeviceStateEnum.getName(Integer.valueOf(this.getDeviceState()));
		}else{
			this.deviceStateName = "";
		}
		
	}

	public String getManagerName() {
		return managerName;
	}

	public void setManagerName(String managerName) {
		this.managerName = managerName;
	}

	private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取分类编号(Devicetype.id)
     *
     * @return type_id - 分类编号(Devicetype.id)
     */
    public Long getTypeId() {
        return typeId;
    }

    /**
     * 设置分类编号(Devicetype.id)
     *
     * @param typeId 分类编号(Devicetype.id)
     */
    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    /**
     * 获取分类名称
     *
     * @return type_name - 分类名称
     */
    public String getTypeName() {
        return typeName;
    }

    /**
     * 设置分类名称
     *
     * @param typeName 分类名称
     */
    public void setTypeName(String typeName) {
        this.typeName = typeName == null ? null : typeName.trim();
    }

    /**
     * 获取设备名称
     *
     * @return device_name - 设备名称
     */
    public String getDeviceName() {
        return deviceName;
    }

    /**
     * 设置设备名称
     *
     * @param deviceName 设备名称
     */
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName == null ? null : deviceName.trim();
    }

    /**
     * 获取设备编号
     *
     * @return device_no - 设备编号
     */
    public String getDeviceNo() {
        return deviceNo;
    }

    /**
     * 设置设备编号
     *
     * @param deviceNo 设备编号
     */
    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo == null ? null : deviceNo.trim();
    }

    /**
     * 获取设备型号
     *
     * @return device_model - 设备型号
     */
    public String getDeviceModel() {
        return deviceModel;
    }

    /**
     * 设置设备型号
     *
     * @param deviceModel 设备型号
     */
    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel == null ? null : deviceModel.trim();
    }

    /**
     * 获取1-正常，2-故障，3-维修，4-报废，5-其他
     *
     * @return device_state - 1-正常，2-故障，3-维修，4-报废，5-其他
     */
    public Byte getDeviceState() {
        return deviceState;
    }

    /**
     * 设置1-正常，2-故障，3-维修，4-报废，5-其他
     *
     * @param deviceState 1-正常，2-故障，3-维修，4-报废，5-其他
     */
    public void setDeviceState(Byte deviceState) {
        this.deviceState = deviceState;
    }

    /**
     * 获取车间编号
     *
     * @return use_area_id - 车间编号
     */
    public String getUseAreaId() {
        return useAreaId;
    }

    /**
     * 设置车间编号
     *
     * @param useAreaId 车间编号
     */
    public void setUseAreaId(String useAreaId) {
        this.useAreaId = useAreaId;
    }

    /**
     * 获取组织名称
     *
     * @return useareaname - 组织名称
     */
    public String getUseareaname() {
        return useareaname;
    }

    /**
     * 设置组织名称
     *
     * @param useareaname 组织名称
     */
    public void setUseareaname(String useareaname) {
        this.useareaname = useareaname == null ? null : useareaname.trim();
    }

    /**
     * 获取安装地点
     *
     * @return install_position - 安装地点
     */
    public String getInstallPosition() {
    	
        return installPosition;
    }

    /**
     * 设置安装地点
     *
     * @param installPosition 安装地点
     */
    public void setInstallPosition(String installPosition) {
        this.installPosition = installPosition == null ? null : installPosition.trim();
    }

    /**
     * 获取生产单位
     *
     * @return manufacturer - 生产单位
     */
    public String getManufacturer() {
        return manufacturer;
    }

    /**
     * 设置生产单位
     *
     * @param manufacturer 生产单位
     */
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer == null ? null : manufacturer.trim();
    }

    /**
     * 获取生产单位
     *
     * @return supplier - 生产单位
     */
    public String getSupplier() {
        return supplier;
    }

    /**
     * 设置生产单位
     *
     * @param supplier 生产单位
     */
    public void setSupplier(String supplier) {
        this.supplier = supplier == null ? null : supplier.trim();
    }

    /**
     * 获取安装单位
     *
     * @return installer - 安装单位
     */
    public String getInstaller() {
        return installer;
    }

    /**
     * 设置安装单位
     *
     * @param installer 安装单位
     */
    public void setInstaller(String installer) {
        this.installer = installer == null ? null : installer.trim();
    }

    /**
     * 获取验收时间
     *
     * @return accept_time - 验收时间
     */
    public Date getAcceptTime() {
        return acceptTime;
    }

    /**
     * 设置验收时间
     *
     * @param acceptTime 验收时间
     */
    public void setAcceptTime(Date acceptTime) {
        this.acceptTime = acceptTime;
    }

    /**
     * 获取投用日期
     *
     * @return use_time - 投用日期
     */
    public Date getUseTime() {
        return useTime;
    }

    /**
     * 设置投用日期
     *
     * @param useTime 投用日期
     */
    public void setUseTime(Date useTime) {
        this.useTime = useTime;
    }

    /**
     * 获取负责人(用户编号)
     *
     * @return managerId - 负责人(用户编号)
     */
    public Long getManagerid() {
        return managerid;
    }

    /**
     * 设置负责人(用户编号)
     *
     * @param managerid 负责人(用户编号)
     */
    public void setManagerid(Long managerid) {
        this.managerid = managerid;
    }

    /**
     * 获取是否产生职业病危害因素
     *
     * @return is_harm - 是否产生职业病危害因素
     */
    public Boolean getIsHarm() {
        return isHarm;
    }

    /**
     * 设置是否产生职业病危害因素
     *
     * @param isHarm 是否产生职业病危害因素
     */
    public void setIsHarm(Boolean isHarm) {
        this.isHarm = isHarm;
    }

    /**
     * 获取是否特种设备
     *
     * @return is_special - 是否特种设备
     */
    public Boolean getIsSpecial() {
        return isSpecial;
    }

    /**
     * 设置是否特种设备
     *
     * @param isSpecial 是否特种设备
     */
    public void setIsSpecial(Boolean isSpecial) {
        this.isSpecial = isSpecial;
    }

    /**
     * 获取是否放射设备
     *
     * @return is_radiation - 是否放射设备
     */
    public Boolean getIsRadiation() {
        return isRadiation;
    }

    /**
     * 设置是否放射设备
     *
     * @param isRadiation 是否放射设备
     */
    public void setIsRadiation(Boolean isRadiation) {
        this.isRadiation = isRadiation;
    }

    /**
     * 获取是否职业病防护设施
     *
     * @return is_devicefh - 是否职业病防护设施
     */
    public Boolean getIsDevicefh() {
        return isDevicefh;
    }

    /**
     * 设置是否职业病防护设施
     *
     * @param isDevicefh 是否职业病防护设施
     */
    public void setIsDevicefh(Boolean isDevicefh) {
        this.isDevicefh = isDevicefh;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 使用岗位
     * @return workrolenames
     */
    public String getWorkrolenames() {
        return workrolenames;
    }

    /**
     * @param workrolenames
     */
    public void setWorkrolenames(String workrolenames) {
        this.workrolenames = workrolenames == null ? null : workrolenames.trim();
    }

    /**
     * @return materials
     */
    public String getMaterials() {
        return materials;
    }

    /**
     * @param materials
     */
    public void setMaterials(String materials) {
        this.materials = materials == null ? null : materials.trim();
    }
    public String getInstallInfo() {
    	return (this.installAreaFullName==null?"":this.installAreaFullName) + " " + (this.installPosition==null?"":this.installPosition);
    }

    public String getStrId() {
        return strId;
    }

    public void setStrId(String strId) {
        this.strId = strId;
    }
}