package cn.smarthse.modules.health.entity.base.device;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "device_info")
public class DeviceInfo implements Serializable {
    /**
     * ID
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 分类编号(Devicetype.id)
     */
    @Column(name = "type_id")
    private Long typeId;

    /**
     * 设备编号
     */
    @Column(name = "device_no")
    private String deviceNo;

    /**
     * 设备名
     */
    @Column(name = "device_name")
    private String deviceName;

    /**
     * 设备型号
     */
    @Column(name = "device_model")
    private String deviceModel;

    /**
     * 数量
     */
    @Column(name = "device_amount")
    private Long deviceAmount = (long)1;

    /**
     * 1-正常，2-故障，3-维修，4-报废，5-其他
     */
    @Column(name = "device_state")
    private Long deviceState;

    /**
     * 车间编号
     */
    @Column(name = "use_area_id")
    private Long useAreaId;

    /**
     * 安装区域编号(Area.ID)
     */
    @Column(name = "install_area_id")
    private Long installAreaId;

    /**
     * 安装地点
     */
    @Column(name = "install_position")
    private String installPosition;

    /**
     * 生产单位
     */
    private String manufacturer;

    /**
     * 供货单位
     */
    private String supplier;

    /**
     * 安装单位
     */
    private String installer;

    /**
     * 出石日期
     */
    @Column(name = "produced_time")
    private Date producedTime;

    /**
     * 验收时间
     */
    @Column(name = "accept_time")
    private Date acceptTime;

    /**
     * 投用日期
     */
    @Column(name = "use_time")
    private Date useTime;

    /**
     * 负责部门部门编号
     */
    @Column(name = "use_dept")
    private Long useDept;

    /**
     * 负责人(用户编号)
     */
    @Column(name = "managerId")
    private Long managerid;

    /**
     * 是否产生职业病危害因素
     */
    @Column(name = "is_harm")
    private Boolean isHarm;

    /**
     * 是否特种设备
     */
    @Column(name = "is_special")
    private Boolean isSpecial;

    /**
     * 是否放射设备
     */
    @Column(name = "is_radiation")
    private Boolean isRadiation;

    /**
     * 1-yes/0-no
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 是否职业病防护设施
     */
    @Column(name = "is_devicefh")
    private Boolean isDevicefh;

    /**
     * 防护用途
     */
    private String purpose;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    
    //特种设备信息
    @Transient
    private DeviceSpecial special;

    //使用岗位
    @Transient
    private String workrolenames;
    //职业病危害因素ids
    @Transient
    private String harmNames;
    /**
     * 报废时间
     */
    @Column(name = "scrap_time")
    private Date scrapTime;

    /**
     * 负责人名称
     */
    @Column(name = "manager_name")
    private String managerName;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return ID - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业id
     *
     * @return cid - 企业id
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业id
     *
     * @param cid 企业id
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取分类编号(Devicetype.id)
     *
     * @return type_id - 分类编号(Devicetype.id)
     */
    public Long getTypeId() {
        return typeId;
    }

    /**
     * 设置分类编号(Devicetype.id)
     *
     * @param typeId 分类编号(Devicetype.id)
     */
    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    /**
     * 获取设备编号
     *
     * @return device_no - 设备编号
     */
    public String getDeviceNo() {
        return deviceNo;
    }

    /**
     * 设置设备编号
     *
     * @param deviceNo 设备编号
     */
    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo == null ? null : deviceNo.trim();
    }

    /**
     * 获取设备名
     *
     * @return device_name - 设备名
     */
    public String getDeviceName() {
        return deviceName;
    }

    /**
     * 设置设备名
     *
     * @param deviceName 设备名
     */
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName == null ? null : deviceName.trim();
    }

    /**
     * 获取设备型号
     *
     * @return device_model - 设备型号
     */
    public String getDeviceModel() {
        return deviceModel;
    }

    /**
     * 设置设备型号
     *
     * @param deviceModel 设备型号
     */
    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel == null ? null : deviceModel.trim();
    }

    /**
     * 获取数量
     *
     * @return device_amount - 数量
     */
    public Long getDeviceAmount() {
        return deviceAmount;
    }

    /**
     * 设置数量
     *
     * @param deviceAmount 数量
     */
    public void setDeviceAmount(Long deviceAmount) {
        this.deviceAmount = deviceAmount;
    }

    /**
     * 获取1-正常，2-故障，3-维修，4-报废，5-其他
     *
     * @return device_state - 1-正常，2-故障，3-维修，4-报废，5-其他
     */
    public Long getDeviceState() {
        return deviceState;
    }

    /**
     * 设置1-正常，2-故障，3-维修，4-报废，5-其他
     *
     * @param deviceState 1-正常，2-故障，3-维修，4-报废，5-其他
     */
    public void setDeviceState(Long deviceState) {
        this.deviceState = deviceState;
    }

    /**
     * 获取车间编号
     *
     * @return use_area_id - 车间编号
     */
    public Long getUseAreaId() {
        return useAreaId;
    }

    /**
     * 设置车间编号
     *
     * @param useAreaId 车间编号
     */
    public void setUseAreaId(Long useAreaId) {
        this.useAreaId = useAreaId;
    }

    /**
     * 获取安装区域编号(Area.ID)
     *
     * @return install_area_id - 安装区域编号(Area.ID)
     */
    public Long getInstallAreaId() {
        return installAreaId;
    }

    /**
     * 设置安装区域编号(Area.ID)
     *
     * @param installAreaId 安装区域编号(Area.ID)
     */
    public void setInstallAreaId(Long installAreaId) {
        this.installAreaId = installAreaId;
    }

    /**
     * 获取安装地点
     *
     * @return install_position - 安装地点
     */
    public String getInstallPosition() {
        return installPosition;
    }

    /**
     * 设置安装地点
     *
     * @param installPosition 安装地点
     */
    public void setInstallPosition(String installPosition) {
        this.installPosition = installPosition == null ? null : installPosition.trim();
    }

    /**
     * 获取生产单位
     *
     * @return manufacturer - 生产单位
     */
    public String getManufacturer() {
        return manufacturer;
    }

    /**
     * 设置生产单位
     *
     * @param manufacturer 生产单位
     */
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer == null ? null : manufacturer.trim();
    }

    /**
     * 获取生产单位
     *
     * @return supplier - 生产单位
     */
    public String getSupplier() {
        return supplier;
    }

    /**
     * 设置生产单位
     *
     * @param supplier 生产单位
     */
    public void setSupplier(String supplier) {
        this.supplier = supplier == null ? null : supplier.trim();
    }

    /**
     * 获取安装单位
     *
     * @return installer - 安装单位
     */
    public String getInstaller() {
        return installer;
    }

    /**
     * 设置安装单位
     *
     * @param installer 安装单位
     */
    public void setInstaller(String installer) {
        this.installer = installer == null ? null : installer.trim();
    }

    /**
     * 获取出石日期
     *
     * @return produced_time - 出石日期
     */
    public Date getProducedTime() {
        return producedTime;
    }

    /**
     * 设置出石日期
     *
     * @param producedTime 出石日期
     */
    public void setProducedTime(Date producedTime) {
        this.producedTime = producedTime;
    }

    /**
     * 获取验收时间
     *
     * @return accept_time - 验收时间
     */
    public Date getAcceptTime() {
        return acceptTime;
    }

    /**
     * 设置验收时间
     *
     * @param acceptTime 验收时间
     */
    public void setAcceptTime(Date acceptTime) {
        this.acceptTime = acceptTime;
    }

    /**
     * 获取投用日期
     *
     * @return use_time - 投用日期
     */
    public Date getUseTime() {
        return useTime;
    }

    /**
     * 设置投用日期
     *
     * @param useTime 投用日期
     */
    public void setUseTime(Date useTime) {
        this.useTime = useTime;
    }

    /**
     * 获取负责部门部门编号
     *
     * @return use_dept - 负责部门部门编号
     */
    public Long getUseDept() {
        return useDept;
    }

    /**
     * 设置负责部门部门编号
     *
     * @param useDept 负责部门部门编号
     */
    public void setUseDept(Long useDept) {
        this.useDept = useDept;
    }

    /**
     * 获取负责人(用户编号)
     *
     * @return managerId - 负责人(用户编号)
     */
    public Long getManagerid() {
        return managerid;
    }

    /**
     * 设置负责人(用户编号)
     *
     * @param managerid 负责人(用户编号)
     */
    public void setManagerid(Long managerid) {
        this.managerid = managerid;
    }

    /**
     * 获取是否产生职业病危害因素
     *
     * @return is_harm - 是否产生职业病危害因素
     */
    public Boolean getIsHarm() {
        return isHarm;
    }

    /**
     * 设置是否产生职业病危害因素
     *
     * @param isHarm 是否产生职业病危害因素
     */
    public void setIsHarm(Boolean isHarm) {
        this.isHarm = isHarm;
    }

    /**
     * 获取是否特种设备
     *
     * @return is_special - 是否特种设备
     */
    public Boolean getIsSpecial() {
        return isSpecial;
    }

    /**
     * 设置是否特种设备
     *
     * @param isSpecial 是否特种设备
     */
    public void setIsSpecial(Boolean isSpecial) {
        this.isSpecial = isSpecial;
    }

    /**
     * 获取是否放射设备
     *
     * @return is_radiation - 是否放射设备
     */
    public Boolean getIsRadiation() {
        return isRadiation;
    }

    /**
     * 设置是否放射设备
     *
     * @param isRadiation 是否放射设备
     */
    public void setIsRadiation(Boolean isRadiation) {
        this.isRadiation = isRadiation;
    }

    /**
     * 获取1-yes/0-no
     *
     * @return is_valid - 1-yes/0-no
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置1-yes/0-no
     *
     * @param isValid 1-yes/0-no
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取是否职业病防护设施
     *
     * @return is_devicefh - 是否职业病防护设施
     */
    public Boolean getIsDevicefh() {
        return isDevicefh;
    }

    /**
     * 设置是否职业病防护设施
     *
     * @param isDevicefh 是否职业病防护设施
     */
    public void setIsDevicefh(Boolean isDevicefh) {
        this.isDevicefh = isDevicefh;
    }

    /**
     * 获取防护用途
     *
     * @return purpose - 防护用途
     */
    public String getPurpose() {
        return purpose;
    }

    /**
     * 设置防护用途
     *
     * @param purpose 防护用途
     */
    public void setPurpose(String purpose) {
        this.purpose = purpose == null ? null : purpose.trim();
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人
     *
     * @return update_by - 最后修改人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人
     *
     * @param updateBy 最后修改人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_data - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateData 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public DeviceSpecial getSpecial() {
		return special;
	}

	public void setSpecial(DeviceSpecial special) {
		this.special = special;
	}


    public Date getScrapTime() {
        return scrapTime;
    }

    public void setScrapTime(Date scrapTime) {
        this.scrapTime = scrapTime;
    }

    public String getWorkrolenames() {
        return workrolenames;
    }

    public void setWorkrolenames(String workrolenames) {
        this.workrolenames = workrolenames;
    }

    public String getHarmNames(){return harmNames;}

    public void setHarmNames(String harmNames) {
        this.harmNames = harmNames;
    }

    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
}