package cn.smarthse.modules.health.entity.base.device;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "device_harmfactor")
public class DeviceHarmfactor implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 设备ID
     */
    @Column(name = "device_id")
    private Long deviceId;

    /**
     * 危害因素名称
     */
    @Column(name = "harm_name")
    private String harmName;

    /**
     * 危害因素ID
     */
    @Column(name = "harm_id")
    private Long harmId;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 是否正常(1-正常,0-删除)
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人staffID
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 修改人staffID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取设备ID
     *
     * @return device_id - 设备ID
     */
    public Long getDeviceId() {
        return deviceId;
    }

    /**
     * 设置设备ID
     *
     * @param deviceId 设备ID
     */
    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    /**
     * 获取危害因素名称
     *
     * @return harm_name - 危害因素名称
     */
    public String getHarmName() {
        return harmName;
    }

    /**
     * 设置危害因素名称
     *
     * @param harmName 危害因素名称
     */
    public void setHarmName(String harmName) {
        this.harmName = harmName == null ? null : harmName.trim();
    }

    /**
     * 获取危害因素ID
     *
     * @return harm_id - 危害因素ID
     */
    public Long getHarmId() {
        return harmId;
    }

    /**
     * 设置危害因素ID
     *
     * @param harmId 危害因素ID
     */
    public void setHarmId(Long harmId) {
        this.harmId = harmId;
    }

    /**
     * 获取企业id
     *
     * @return cid - 企业id
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业id
     *
     * @param cid 企业id
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取是否正常(1-正常,0-删除)
     *
     * @return is_valid - 是否正常(1-正常,0-删除)
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否正常(1-正常,0-删除)
     *
     * @param isValid 是否正常(1-正常,0-删除)
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人staffID
     *
     * @return create_by - 创建人staffID
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人staffID
     *
     * @param createBy 创建人staffID
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取修改人staffID
     *
     * @return update_by - 修改人staffID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置修改人staffID
     *
     * @param updateBy 修改人staffID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取修改时间
     *
     * @return update_data - 修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置修改时间
     *
     * @param updateData 修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}