package cn.smarthse.modules.health.entity.base.device;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * @author Denglibin
 * @date 2021/12/17 16:50
 * @desc 摄像机上报数据
 */
@Data
public class CameraRecord implements Serializable {

    /**
     * ID
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;


    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;


    private String faceId;//'比对成功的人员UUID',
    private Integer act;//'是否比对成功 数字 是 0 为比对失败，1 为比对成功',
    private Integer score;//相似度 数字 是 和入库人脸相比，相似程度（1-100）',
    private Long datetime;//比对时间 时间戳',
    private String image;//'人脸图片',
    private String ip;//'设备 IP 地址 String 是 设备地址',
    private Integer age;//'年龄 数字 0，设备未进行检测',
    private Integer gender;//'性别 数字 0，设备未进行检测；1，男；2，女 ',
    private Integer glasses;//'眼镜 数字 0，设备未进行检测；1，未戴镜；2，眼镜；3，太阳镜',
    private Integer mask;//'遮挡 数字 0，设备未进行检测；1，未遮挡；2，遮挡',
    private Integer race ;//'脸色 数字 0，设备未进行检测；1，黄色；2，黑色；3，白色',
    private Integer beard;//'胡须 数字 0，设备未进行检测；1，没有胡须；2，有胡须',
    private Integer expression;//'表情 数字 0，设备未进行检测；1-愤怒；2-平静；3-快乐；4-悲伤；5-惊讶',
    private String iccard;//comment '卡号 数字 录入时或刷卡时的 IC 卡号',
    private Integer role ;//'黑白名单 数字',
    private String mac;//'设备 MAC String 设备 MAC 地址', mac地址作为设备表online_device 的设备编号(device_no) 来关联设备表
    private String bgImage;//'背景图片',
    private String temperature;//'测温数据',

    //人脸位置
    private Integer x;
    private Integer y;
    private Integer w;
    private Integer h;


}
