package cn.smarthse.modules.health.entity.base.company.role;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "company_role_relation")
public class CompanyRoleRelation implements Serializable {
    /**
     * ID
     */
    @Id
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 企业角色ID
     */
    @Column(name = "company_role_id")
    private Long companyRoleId;

    /**
     * 角色生效开始时间
     */
    @Column(name = "begin_date")
    private Date beginDate;

    /**
     * 角色生效结束时间
     */
    @Column(name = "end_date")
    private Date endDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取企业角色ID
     *
     * @return company_role_id - 企业角色ID
     */
    public Long getCompanyRoleId() {
        return companyRoleId;
    }

    /**
     * 设置企业角色ID
     *
     * @param companyRoleId 企业角色ID
     */
    public void setCompanyRoleId(Long companyRoleId) {
        this.companyRoleId = companyRoleId;
    }

    /**
     * 获取角色生效开始时间
     *
     * @return begin_date - 角色生效开始时间
     */
    public Date getBeginDate() {
        return beginDate;
    }

    /**
     * 设置角色生效开始时间
     *
     * @param beginDate 角色生效开始时间
     */
    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    /**
     * 获取角色生效结束时间
     *
     * @return end_date - 角色生效结束时间
     */
    public Date getEndDate() {
        return endDate;
    }

    /**
     * 设置角色生效结束时间
     *
     * @param endDate 角色生效结束时间
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}