package cn.smarthse.modules.health.entity.base.company.grade.vo;

import lombok.Data;

import java.io.Serializable;
@Data
public class GradeSearchV311 implements Serializable {
    /**
     * @Comments:  <分级分类V311>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @param  type 1:occupationalRiskClassify (subType=职业病危害风险分类 0-严重、1-较重、2-一般 3-未细分 4-未划分 )   行业职业病危害风险类别
     *             2:judgeLevel (subType=职业健康管理状况等级 0:未评定 1:A级 2:B级 3:C级)       职业健康管理状况等级
     *             3:riskLevel (subType=职业病危害暴露风险等级 0:未评定 1:低风险2:中风险3:高风险)      职业病危害暴露风险等级
     *             4:riskClassify (subType=职业病危害综合风险类别 0:未评定 1:甲类2:乙类3:丙类)          职业病危害综合风险类别
     * @since 下午4:12 2022/1/12
     **/
    private Integer type;

    private Integer subType;

    private Long areaId;

    private Byte areaLevel;
    private Long orgAreaId;

    private Byte orgAreaLevel;

    /**
     * 1 当年， 2历年
     */
    private Integer dataYear;
    /**
     * 业务数据年份
     */
    private Integer gradeYear;
    private Integer onlyLaborDispatch;
    private String victimsCase;
    private String gradeSource;

    /**
     * 是否粉尘一体化企业   1是， 0否
     */
    private Integer isFcImportanceCompany;
}
