package cn.smarthse.modules.health.entity.base.company.grade.vo;

import cn.smarthse.modules.datacentre.enums.CompanyOccTypeEnum;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3;
import cn.smarthse.modules.health.enums.home.govern.CompanyGovernRiskTypeEnum;
import cn.smarthse.modules.health.enums.home.grade.CompanyGradeEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import lombok.Data;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 企业信息-分级分类表-第三版
 * </p>
 *
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2022-01-10
 */
@Data
public class CompanyGradeVoV3 extends CompanyGradeV3 {


    @Transient
    private String companyName;

    @Transient
    private  String  locationAddress;

    @Transient
    private  Long  areaId;

    /**
     * 一般职业病危害因素-超标人数  》》》接触人数
     */
    @Deprecated
    private Long generalOverStaffCount;
    //一般危害因素 接触人数
    private Integer oneTouchNum=0;

    //严重危害因素 接触人数
    private Integer twoTouchNum = 0;

    //超标情况
    private String generalOverStaffCountStr="无";

    /**
     * 一般职业病危害因素-不超标人数
     */

    @Deprecated
    private Long generalNotOverStaffCount;

    /**
     * 严重职业病危害因素-超标人数
     */

    @Deprecated
    private Long seriousOverStaffCount;

    //超标情况
    private String seriousOverStaffCountStr="无";
    /**
     * 严重职业病危害因素-不超标人数
     */

    @Deprecated
    private Long seriousNotOverStaffCount;

    private String provinceName;

    private String  cityName;

    private  String areaName;

    private String streetName;

    private String industryCategoryName;


    /**
     * 职业健康管理状况等级
     */
    private String judgeLevelName;


    /**
     * 职业病危害暴露风险等级
     */
    private String riskLevelName;
    /**
     * 职业病危害综合风险类别
     */
    private String riskClassifyName;
    /**
     * 企业职业病危害风险类别
     */
    private String occTypeName;

    /**
     * 综合风险分类
     */
    private String gradeName;


    private Integer byIndu;

    public String getJudgeLevelName() {
        if (this.getJudgeLevel() != null) {
            return JudgeResultLevelEnum.getNameByCode(this.getJudgeLevel());
        }
        return "未评定";
    }

    public String getRiskTypeName() {
        if (this.getRiskType() != null) {
            return CompanyGovernRiskTypeEnum.getName(this.getRiskType());
        }
        return "";
    }

    public String getRiskLevelName() {
        if (this.getRiskLevel() != null) {
            return HazardsExposureRiskLevelEnum.getNameByCode(this.getRiskLevel());
        }
        return "未评定";
    }

    public String getRiskClassifyName() {
        if (this.getRiskClassify() != null) {
            return CompanyGradeEnum.getName(this.getRiskClassify().byteValue());
        }
        return "未评定";
    }

    public String getOccTypeName() {
        if (this.getOccType() != null) {
            return CompanyOccTypeEnum.getName(this.getOccType());
        }
        return "未划分";
    }

    public String getGradeName() {
        if (this.getGrade() != null) {
            return CompanyGradeEnum.getName(this.getGrade().byteValue());
        }
        return "未评定";
    }

}
