package cn.smarthse.modules.health.entity.base.company.grade;

import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: GradeWorkProgressVo
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 19
 * @since 2022/11/7-18:19
 */
@Data
public class CompanyGradeWorkProgress implements Serializable {
    @Id
    private Long id;
    private Long areaId;
    @Transient
    private Integer areaLevel;
    @Transient
    private Long rid;
    @Transient
    private Long pid;
    @Transient
    private String areaName;
    private Integer dataYear;
    private Integer grade;
    private String keyIndu;
    private Integer gradeTotalNum;
    private Integer than2gradeTotalNum;
    private Integer than2gradeSelfNum;
    private Integer than2gradeFinishNum;
    private Integer than2gradeRiskNum;
    private Integer gradeFinishNum;
    /**
     * @description 【未完成审核数】，统计“综合风险评估报告”未曾审核通过的企业 
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @date 2025/4/3 14:28
     */
    private Integer gradeNocheckNum;
    /**
     * @description 新增字段【未分类完成企业数】
     * 接害人数≥3人或无数据的企业：无“分类自查”、“”依据风险未及时化解、“依据监管认定”、“依据信用监管”分类结果
     * 接害人数＜3人企业：无“分类自查”、“依据接害人数＜3人”、“依据风险未及时化解”、“依据监管认定”、“依据信用监管”分类结果
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @date 2025/4/10 10:30
     */
    private Integer gradeNofinishNum;
    /**
     * @description 新增字段【分类完成率】
     * 分类完成率=有“除去行业分类”以外的分类结果的企业/分类企业数
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @date 2025/4/10 10:53
     */
    private double gradeFilterInduFinishRate;
    @Transient
    private double gradeFinishRate;
    @Transient
    private double closeFinishRate;
    @Transient
    private double closeSelfRate;
    private Integer gradeClassaNum;
    private Integer gradeClassbNum;
    private Integer gradeClasscNum;
    private Integer than2gradeClassaNum;
    private Integer than2gradeClassbNum;
    private Integer than2gradeClasscNum;
    private Integer gradeSelfNum;
    private Integer checkState;
    private Integer belongType;
    @Transient
    private String gradeSelfRate;
    private Integer gradeRiskNum;
    @Transient
    private String gradeRiskRate;
    @Transient
    private Integer stage;
    private String stageName;


    @Transient
    private Integer stage1;
    private String stage1Name;
    @Transient
    private Integer stage2;
    @Transient
    private String stage2Name;
    @Transient
    private Integer stage3;
    @Transient
    private String stage3Name;



    public String getStage1Name() {
        if (this.getStage1() == null) {
            return "-";
        }else {
            if (this.getStage1() == 0) {
                return "否";
            }else {
                return "是";
            }
        }
    }

    public String getStage2Name() {
        if (this.getStage2() == null) {
            return "-";
        }else {
            if (this.getStage2() == 0) {
                return "否";
            }else {
                return "是";
            }
        }
    }

    public String getStage3Name() {
        if (this.getStage3() == null) {
            return "-";
        }else {
            if (this.getStage3() == 0) {
                return "否";
            }else {
                return "是";
            }
        }
    }

    @Transient
    private Long belongid;
    @Transient
    private String cityName;

    /**
     * 当前所处阶段
     */
    @Transient
    private Integer currStage;

    //丙类中 重点行业企业数
    @Transient
    private Integer classcIndus;
    //重点行业企业数
    @Transient
    private Integer impindu;
    /**
     * 丙类企业中 重点行业占比
     */
    @Transient
    private double classcIndusRate;
    /**
     * 丙类企业占比
     */
    @Transient
    private double classcRate;

    private Date updateDate;

    @Transient
    private int idx;

    /**
     * 查询分类备份数据, 2023, 20240223
     */
    @Transient
    private String gradeYear;
    // 结算日期
    @Transient
    private String closeDate;

    /**
     * 查询分类备份数据, 2023, 20240223
     */
    @Transient
    private String dataType;
    public String getStageName() {
        if (this.getStage() == null) {
            return "-";
        }else {
            if (this.getStage() == 0) {
                return "否";
            }else {
                return "是";
            }
        }
    }

}
