package cn.smarthse.modules.health.entity.base.company.grade;

import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 * 企业信息-分级分类表-第三版-审核记录表
 * </p>
 *
 * @author zhoulj@smarthse.cn
 * @since 2022-07-18
 */
@Data
public class CompanyGradeV3Rec implements Serializable {

    private static final long serialVersionUID = 1L;

//    @ApiModelProperty(value = "ID")
    @Id
    private Long id;

//    @ApiModelProperty(value = "企业id")
    private Long cid;

//    @ApiModelProperty(value = "职业卫生分类 1甲类 2 乙类   3丙类")
    private Integer grade;
    /**
     * 0无来源， 1接害三人以下企业 2 分类自查 3 根据行业划分  4 依据容错自纠调整
     */
    private Integer gradeSource;
    private Integer induGrade;

    private Integer addOccNum;

//    @ApiModelProperty(value = "评级时间")
    private LocalDateTime gradeTime;

//    @ApiModelProperty(value = "评估类型， 1首次评估, 2变更")
    private Integer evaluateType;

//    @ApiModelProperty(value = "职业健康管理状况等级")
    private Integer judgeLevel;

//    @ApiModelProperty(value = "职业病危害暴露风险等级")
    private Integer riskLevel;

//    @ApiModelProperty(value = "企业职业病危害风险类别,默认为4 未划分")
    private Integer occType;

//    @ApiModelProperty(value = "是否通过行业计算的分级分类")
    private Integer byIndu;

    private Boolean isGovern;

//    @ApiModelProperty(value = "审核状态：1已审核，0默认未评估")
    private Integer checkState;
    private Date checkTime;

//    @ApiModelProperty(value = "创建人")
    private Long createBy;

//    @ApiModelProperty(value = "创建时间")
    private Date createDate;

//    @ApiModelProperty(value = "最后修改人ID")
    private Long updateBy;

//    @ApiModelProperty(value = "最后修改时间")
    private Date updateDate;

//    @ApiModelProperty(value = "是否有效")
    private Integer isValid;


    @Transient
    private Boolean isDecCurrentYear;
    @Transient
    private String changeReason;
    @Transient
    private Long areaId;
    private Byte isBest;

}
