package cn.smarthse.modules.health.entity.base.company.grade;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 企业信息-分级分类表-变更为丙类企业
 */
@Data
@Accessors(chain = true)
@Table(name = "company_grade_v3_change_classc")
public class CompanyGradeV3ChangeClassc implements Serializable {

    private static final long serialVersionUID = -3868014053403087362L;

    /**
     * ID
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 评估报告id
     */
    private Long evaluateId;

    /**
     * 变更id，关联：test2.company_change_info.id
     */
    private Long changeId;

    /**
     * 变更为丙类企业 审核时间
     */
    private Date changeTime;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 是否有效
     */
    private Boolean isValid;
}
