package cn.smarthse.modules.health.entity.base.company.grade;

import cn.smarthse.modules.health.enums.home.grade.GradeSourceEnum;
import lombok.Data;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;

/**
 * <p>
 * 企业信息-分级分类表-第三版
 * </p>
 *
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2022-01-10
 */
@Data
public class CompanyGradeV3 implements Serializable {

    private static final long serialVersionUID = 1L;

    public CompanyGradeV3() {

    }
    public CompanyGradeV3(Long cid) {
        this.cid = cid;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    private Long cid;
    @Transient
    private Long areaId;

    @Transient
    private Long industryCategory;
    @Transient
    /**
     * @description
     * @author zhoulj(1210172780@qq.com)
     * @date 2025/5/22 9:01
     * @param null
     * @return null
     */
    private String induHarmLevel;
    /**
     * 职业卫生分类 1甲类 2 乙类   3丙类， 默认0
     */
    private Integer grade;
    @Transient
    private GradeSourceEnum gradeSourceEnum=GradeSourceEnum.NOSOURCE;;
    // 认定
    private boolean isIdentifiedClassc=false;

    private Integer induGrade;
    private Integer realGrade;
    /**
     * 评级时间
     */
    private LocalDateTime gradeTime;
    /**
     * 新增职业病人数
     */
    private Integer addOccNum;
    /**
     * 自查id
     */
    private Long selfId;

    //默认tableType=1时和原来一样，tableType=2时就是显示两个机构
    @Transient
    private Integer tableType=1;
    //tableType=1用 调查风险评估表id
    private Long riskId;
    //tableType=2需要分别退回时用下面的两个id，如果是退回两个分别调两次原来的接口（没有写一次退回两个的接口）
    //放射检测机构的暴露id
    @Transient
    private Long riskId1;
    //职业健康体检机构的暴露id
    @Transient
    private Long riskId2;

    private Long evaluateId;
    /**
     * 职业健康管理状况等级
     */
    private Integer judgeLevel;
    @Transient
    private Integer realJudgeLevel;
    /**
     * 职业病危害暴露风险等级
     */
    private Integer riskLevel;
    /**
     * 职业病危害综合风险类别
     */
    private Integer riskClassify;
    /**
     * 企业职业病危害风险类别
     */
    private Integer occType;
    /**
     * 2 定期检测 4 控制评价， 9行业
     */
    @Transient
    private Integer occTypeSource;

    /**
     * 评估类型， 1首次评估, 2变更
     */
    private Integer evaluateType=1;


    /**
     * 风险类型:1甲类、高风险、严重  2高风险、A级  3严重、乙类或丙类
     */
    private Integer riskType;

    /**
     * 重点核查对象, 1:职业病危害暴露风险类别为高风险、职业卫生管理状况等级为A级的用人单位；2:严重职业病危害行业、职业病危害综合风险为丙类的用人单位
     */
    private Integer importantCheck;
    private Long createBy;

    private LocalDateTime createDate;

    private Long updateBy;

    private LocalDateTime updateDate;

    private Integer isValid;
    /**
     * 接害人数
     * （接害人数有四个来源-但不采用从体检结果生成的人员列表：
     * 同一个年度的：申报数据＞职业病危害因素接触一览表＞编辑的结果；
     * 不同年度的，取最新的为准）
     *
     * ——新增一个来源：职业病危害因素接触一览表（不同车间、不同岗位定员的加和）
     */
//    private Integer harmStaffNum;

    // 处罚次数
    @Transient
    private Integer punishNum;
    // 接害人数
    @Transient
    private Integer pickupCount;
    @Transient
    private Integer pickupCountSource;
    // 直属企业类型：， 0非直属， 1省直属，2市属
    @Transient
    private Integer belongType;

    private Integer evaluateCheckState=3;
    private Integer jugdeCheckState=3;
    private Integer riskCheckState=3;
    /**
     * 审核状态： 审核状态： 0待审核，-1已退回，1已审核，2有待审核的项 3默认未评估
     */
    private Integer checkState=3;

    private Date riskUpdateDate;
    private Date jugdeUpdateDate;
    private Date evaluateUpdateDate;
    private Boolean riskHasUpdate;
    @Deprecated
    private Boolean judgeHasUpdate;
    @Transient
    private Boolean isDecCurrentYear;

    /**
     * 历年分类对象
     */
    @Transient
    private Boolean isDecOld;
    @Transient
    private String changeReason;
    @Transient
    private Byte isBest;
    @Transient
    private Integer companyType;

    /**
     * 是否治理企业
     */
    private Boolean isGovern;


    /**
     * 是否监督对象
     */
    @Transient
    private Boolean isSupervise;

    /**
     * 是否监督对象
     */
    @Transient
    private Boolean isCompliance;
    /**
     * 信用监管
     */
    @Transient
    private Integer creditSupervise;;


    //当年接害人数是否被监管判定(0-否，1-接害人数<3，2-接害人数≥3)
//    @Transient
//    private Integer victimsIdentify;
    @Transient
    private Integer isShowVictims;

    /**
     * 处理有评级 但是未审核的数据
     * @param companyGradeV3
     * @return
     */
    public static CompanyGradeV3 auditGradeInfo(CompanyGradeV3 companyGradeV3) {
        if (companyGradeV3 != null) {
            if (!Objects.equals(1, companyGradeV3.getEvaluateCheckState())||
                    !Objects.equals(1, companyGradeV3.getJugdeCheckState()) ||
                    !Objects.equals(1, companyGradeV3.getRiskCheckState())) {
                CompanyGradeV3 temp = new CompanyGradeV3();
                temp.setId(companyGradeV3.getId());
                temp.setCid(companyGradeV3.getCid());
                temp.setGrade(companyGradeV3.getGrade());
                temp.setOccType(companyGradeV3.getOccType());
                return temp;
            }
            return companyGradeV3;
        }
        return companyGradeV3;
    }

}
