package cn.smarthse.modules.health.entity.base.company.govern;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanyGrade
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 19
 * @since 2020/7/8-20:19
 */
@Data
@Table(name = "company_govern")
public class CompanyGovern implements Serializable {
    /**
     * ID
     */
    @Id
    @Column(name = "id")
    private Long id;

    /**
     * 企业id
     */
    @Column(name = "cid")
    private Long cid;

    @Column(name = "area_id")
    private Long areaId;

    /**
     * 治理企业整改情况:  0整改无望、1整改超时、2整改中、3已整改,   -1 异常数据
     */
    @Column(name = "reform_status")
    private Integer reformStatus;

//    `require_finish_time` datetime DEFAULT NULL COMMENT '要求完成时间',
//            `actual_finish_time` date DEFAULT NULL COMMENT '实际完成时间',
    /**
     * 要求完成时间：
     */
    @Column(name = "require_finish_time")
    private Date requireFinishTime;
    /**
     * 实际完成时间：
     */
    @Column(name = "actual_finish_time")
    private Date actualFinishTime;
    /**
     * 治理时间：
     */
    @Column(name = "govern_time")
    private Date governTime;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效
     */
    @Column(name = "is_valid")
    private Byte isValid;


}