package cn.smarthse.modules.health.entity.base.company;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;


/**
 * 《万达仓申报数据》
 * 
 *
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author XiaoYi（肖奕)
 * @since 2022年10月31日-下午1:47:21
 */
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public @Data class WandaDeclare implements Serializable {

	private static final long serialVersionUID = 1L;
	/**
	 * 
	 */
	@Id
	private Long id;
	/**
	 * 企业id
	 */
	private Long cid;
	/**
	 * 申报记录唯一标识sourceId
	 */
	private String sourceId;

	/**
	 * 申报时间
	 */
	private Date declareTime;

	/**
	 * 申报年份
	 */
	private String declareYear;
	/**
	 * 申报类型 0:初次申报,1:变更申报, 2:年度变更
	 */
	private String declareType;
	/**
	 * 变更原因
	 */
	private String changeReason;

	/**
	 * 单位名称
	 */
	private String empName;
	/**
	 * 统一社会信用代码
	 */
	private String creditCode;
	/**
	 * 用人单位注册地
	 */
	private String areaCode;
	/**
	 * 单位注册地址
	 */
	private String regAddr;
	/**
	 * 工作场所地址
	 */
	private String workAddr;
	/**
	 * 工作场所详细地址
	 */
	private String workAddrDetail;
	/**
	 * 企业规模
	 */
	private String enterpriseSize;
	/**
	 * 行业分类
	 */
	private String industryCode;
	/**
	 * 经济类型
	 */
	private String economic;
	/**
	 * 法定代表人
	 */
	private String legalPerson;
	/**
	 * 法定代表人联系电话
	 */
	private String legalPhone;
	/**
	 * 职业卫生管理联系人
	 */
	private String healthManager;
	/**
	 * 职业卫生管理联系人电话
	 */
	private String healthManagerPhone;

	/**
	 * 本单位在册职工总数
	 */
	private String staffNum;
	/**
	 * 外委人员总数
	 */
	private String externalNum;
	/**
	 * 接害总人数（含外委）
	 */
	private String victimsNum;
	/**
	 * 职业病累计人数
	 */
	private String occDiseasesNum;
	/**
	 * 主要负责人培训情况
	 */
	private String leadersTrain;
	/**
	 * 职业卫生管理人员培训情况
	 */
	private String managersTrain;
	/**
	 * 接触职业病危害因素年度培训总人数
	 */
	private String trainSum;

	/**
	 * 是否检测
	 */
	private String isCheck;
	/**
	 * 检测报告编号
	 */
	private String jcbgbh;
	/**
	 * 检测机构名称
	 */
	private String jcjgmc;
	/**
	 * 是否体检
	 */
	private String isDevelop;
	/**
	 * 体检报告编号
	 */

	private String reportCode;
	/**
	 * 体检机构名称
	 */

	private String tjjgmc;
	 /**
     * 是否军工产品
     */
    private String isMilitary;
	/**
	 * 是否存在粉尘
	 */
	private String isExistDust;
	/**
	 * 粉尘接触人数
	 */
	private String dustContactNum;
	/**
	 * 粉尘体检人数
	 */
	private String dustExamNum;
	/**
	 * 粉尘检测人数
	 */
	private String dustCheckNum;
	/**
	 * 粉尘检测超标点数
	 */
	private String dustDetectExceedPoints;
	/**
	 * 是否存在化学因素
	 */
	private String isExistChemistry;
	/**
	 * 化学因素接触人数
	 */
	private String chemistryContactNum;
	/**
	 * 化学因素体检人数
	 */

	private String chemistryExamNum;
	/**
	 * 化学因素检测人数
	 */

	private String chemistryCheckNum;
	/**
	 * 化学因素检测超标点数
	 */

	private String chemistryDetectExceedPoints;
	/**
	 * 是否存在物理因素
	 */

	private String isExistPhysics;
	/**
	 * 物理因素接触人数
	 */

	private String physicsContactNum;
	/**
	 * 物理因素体检人数
	 */

	private String physicsExamNum;
	/**
	 * 物理因素检测人数
	 */

	private String physicsCheckNum;
	/**
	 * 物理因素检测超标点数
	 */

	private String physicsDetectExceedPoints;
	/**
	 * 是否存在放射性因素
	 */

	private String isExistRadiation;
	/**
	 * 放射性因素接触人数
	 */

	private String radiationContactNum;
	/**
	 * 放射性因素体检人数
	 */

	private String radiationExamNum;
	/**
	 * 放射性因素检测人数
	 */

	private String radiationCheckNum;
	/**
	 * 放射性因素检测超标点数
	 */

	private String radiationDetectExceedPoints;
	/**
	 * 是否存在生物因素
	 */

	private String isExistBiology;
	/**
	 * 生物因素接触人数
	 */

	private String biologyContactNum;
	/**
	 * 生物因素体检人数
	 */

	private String biologyExamNum;
	/**
	 * 生物因素检测人数
	 */

	private String biologyCheckNum;
	/**
	 * 生物因素检测超标点数
	 */

	private String biologyDetectExceedPoints;
	/**
	 * 是否存在其他因素
	 */

	private String isExistOtherFactor;
	/**
	 * 其他因素接触人数
	 */

	private String otherFactorContactNum;
	/**
	 * 其他因素体检人数
	 */

	private String otherFactorExamNum;
	/**
	 * 其他因素检测人数
	 */

	private String otherFactorCheckNum;
	/**
	 * 其他因素检测超标点数
	 */
	private String qtysjccbds;
	/**
	 * 接触人数
	 */

	private String contactNum;

	//  判断是否是分类企业
	@Transient
	private Boolean isDec;

	/**
	 * 创建时间
	 */
	private Date createDate;
	private Date bizTime;
	private Date loadTime;

	/**
	 * 创建人
	 */
	private Long createBy;

	/**
	 * 最后修改时间
	 */
	private Date updateDate;

	/**
	 * 最后修改人id
	 */
	private Long updateBy;

	/**
	 * 是否有效（0-无效，1-有效）
	 */
	private Boolean isValid;

}
