package cn.smarthse.modules.health.entity.base.company;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanyGradeHis
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 19
 * @since 2020/7/8-20:19
 */
@Data
@Table(name = "company_zj_grade_his")
public class CompanyZjGradeHis implements Serializable {
    /**
     * ID
     */
    @Id
    @Column(name = "id")
    private Long id;

//    @Column(name = "area_id")
//    private Long areaId;
    /**
     * 企业id
     */
    @Column(name = "cid")
    private Long cid;

    /**
     * 职业卫生分类 1甲类 2 乙类   3丙类
     */
    @Column(name = "grade")
    private Byte grade;

    /**
     * 变更原因
     */
    @Column(name = "reason")
    private String reason;
    /**
     * 评级时间
     */
    @Column(name = "grade_time")
    private Date gradeTime;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Integer createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效
     */
    @Column(name = "is_valid")
    private Byte isValid;

    public String getGradeName() {
        if (this.getGrade() == null) {
            return "";
        }
        switch (this.getGrade()) {
            case 1:
                return "甲类";
            case 2:
                return "乙类";
            case 3:
                return "丙类";
            default:
                return "";
        }

    }
}