package cn.smarthse.modules.health.entity.base.company;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanyGrade
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 19
 * @since 2020/7/8-20:19
 */
@Data
@Table(name = "company_zj_grade")
public class CompanyZjGrade implements Serializable {
    /**
     * ID
     */
    @Id
    @Column(name = "id")
    private Long id;

    /**
     * 企业id
     */
    @Column(name = "cid")
    private Long cid;

//    @Column(name = "area_id")
//    private Long areaId;

    /**
     * 职业卫生分类 1甲类 2 乙类   3丙类
     */
    @Column(name = "grade")
    private Byte grade;

    /**
     * 创建时间
     */
    @Column(name = "grade_time")
    private Date gradeTime;
    /**
     * 因行业列入 甲类
     */
    @Column(name = "industry")
    private String industry;
    @Transient
    private Long industryId;
    @Transient
    private Boolean govern2;
    @Transient
    private int gradeFlag= 0;
    @Column(name = "industry_name")
    private String industryName;

    /**
     * 因高危危害的浓度与行动水平比较（注2） 甲类
     */
    @Column(name = "high_risk")
    private String highRisk ;

    /**
     * 因指定危害的浓度与接触水平比较（注3） 甲类
     */
    @Column(name = "some_harm")
    private String someHarm;

    /**
     * 因化学因素 甲类
     */
    @Column(name = "chemistry")
    private String chemistry ;

    /**
     * 因矽尘 甲类
     */
    @Column(name = "dust")
    private String dust;

    /**
     * 因放射性危害 甲类
     */
    @Column(name = "radiation")
    private String radiation ;

    /**
     * 因近2年新增职业病 甲类
     */
    @Column(name = "add_occ")
    private Integer addOcc;

    /**
     * 因列入重点治理范围 甲类
     */
    @Column(name = "govern")
    private String govern;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效
     */
    @Column(name = "is_valid")
    private Byte isValid;

    public String getGradeName() {
        if (this.getGrade() == null) {
            return "";
        }
        switch (this.getGrade()) {
            case 1:
                return "甲类";
            case 2:
                return "乙类";
            case 3:
                return "丙类";
            default:
                return "";
        }

    }

}