package cn.smarthse.modules.health.entity.base.company;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.validation.DataValida;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;

@Table(name = "company_technology_process")
public class CompanyTechnologyProcess implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 工艺名称
     */
    @DataValida(maxLength="50",minLength="1",nullAble=false,name="工艺名称",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "technology_name")
    private String technologyName;

    /**
     * 描述
     */
    private String description;

    /**
     * 图像附件（文件ID，以逗号隔开）
     */
    @DataValida(maxLength="1000",name="图像附件")
    @Column(name = "image_files")
    private String imageFiles;

    /**
     * 工艺流程附件名称
     */
    @Transient
    private String imageFileNames ;
    
    /**
     * 工艺流程附件
     */
    @Transient
    List<SysFileModel> imageFileList = new ArrayList<SysFileModel>();
    
    /**
     * 编制人姓名（冗余），创建人对应
     */
    @Column(name = "staff_name_compile")
    private String staffNameCompile;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取工艺名称
     *
     * @return technology_name - 工艺名称
     */
    public String getTechnologyName() {
        return technologyName;
    }

    /**
     * 设置工艺名称
     *
     * @param technologyName 工艺名称
     */
    public void setTechnologyName(String technologyName) {
        this.technologyName = technologyName == null ? null : technologyName.trim();
    }

    /**
     * 获取描述
     *
     * @return description - 描述
     */
    public String getDescription() {
        return description;
    }

    /**
     * 设置描述
     *
     * @param description 描述
     */
    public void setDescription(String description) {
        this.description = description == null ? null : description.trim();
    }

    /**
     * 获取图像附件（文件ID，以逗号隔开）
     *
     * @return image_files - 图像附件（文件ID，以逗号隔开）
     */
    public String getImageFiles() {
        return imageFiles;
    }

    /**
     * 设置图像附件（文件ID，以逗号隔开）
     *
     * @param imageFiles 图像附件（文件ID，以逗号隔开）
     */
    public void setImageFiles(String imageFiles) {
        this.imageFiles = imageFiles == null ? null : imageFiles.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getStaffNameCompile() {
		return staffNameCompile;
	}

	public void setStaffNameCompile(String staffNameCompile) {
		this.staffNameCompile = staffNameCompile;
	}

	public List<SysFileModel> getImageFileList() {
		return imageFileList;
	}

	public void setImageFileList(List<SysFileModel> imageFileList) {
		this.imageFileList = imageFileList;
	}

    public String getImageFileNames() {
        return imageFileNames;
    }

    public void setImageFileNames(String imageFileNames) {
        this.imageFileNames = imageFileNames;
    }
}