package cn.smarthse.modules.health.entity.base.company;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《企业软件信息表》
 * 记录企业对应软件的版本,有效期
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-19-下午1:36:43
 */
@Table(name = "company_soft")
public @Data class CompanySoft implements Serializable {
	private static final long serialVersionUID = 6713689224324572434L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 所属企业编号(所在企业)
     */
    private Long cid;

    /**
     * 平台企业ID
     */
    @Column(name = "platform_cid")
    private Long platformCid;

    /**
     * 平台企业软件ID
     */
    @Column(name = "platform_soft_id")
    private Long platformSoftId;
    
    /**
     * 软件版本信息(版本名称)
     */
    @Column(name = "soft_version")
    private String softVersion;

    /**
     * 版本设定编号
     */
    @Column(name = "soft_version_code")
    private String softVersionCode;

    /**
     * 开始时间
     */
    @Column(name = "soft_start_date")
    private Date softStartDate;

    /**
     * 结束日期
     */
    @Column(name = "soft_end_date")
    private Date softEndDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

}