package cn.smarthse.modules.health.entity.base.company;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 *
 */
@Table(name="company_report_info")
@Data
public class CompanyReportInfo implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * cid
     */
    private Long cid;


    /**
     * 管理机构
     */
    @Column(name = "manage_org")
    private String manageOrg;

    /**
     * 机构成立文件
     */
    @Column(name = "manage_org_files")
    private String manageOrgFiles;
    @Column(name = "manage_major_staff_count")
    private Long manageMajorStaffCount=0L;

    /**
     * 职业卫生管理人数-兼职
     */
    @Column(name = "manage_plurality_staff_count")
    private Long managePluralityStaffCount=0L;


    /**
     * 劳动者总人数（含外委）
     */
    @Column(name = "staff_count")
    private Long staffCount;

    /**
     * 接触职业病危害总人数（含外委）
     */
    @Column(name = "harm_staff_count")
    private Long harmStaffCount;

    /**
     * 职业病累计人数-目前在岗
     */
    @Column(name = "disease_on_work_staff_count")
    private Long diseaseOnWorkStaffCount;


    //===================
    /**
     * 职业健康检查人数（含外委-上岗应检
     */
    @Column(name = "check_go_work_staff_count")
    private Long checkGoWorkStaffCount;

    /**
     * 职业健康检查人数（含外委-在岗应检
     */
    @Column(name = "check_on_work_staff_count")
    private Long checkOnWorkStaffCount;

    /**
     * 职业健康检查人数（含外委-离岗应检
     */
    @Column(name = "check_leave_work_staff_count")
    private Long checkLeaveWorkStaffCount;

    /**
     * 职业健康检查人数（含外委-上岗实检
     */
    @Column(name = "check_go_work_staff_real_count")
    private Long checkGoWorkStaffRealCount;

    /**
     * 职业健康检查人数（含外委-在岗实检
     */
    @Column(name = "check_on_work_staff_real_count")
    private Long checkOnWorkStaffRealCount;

    /**
     * 职业健康检查人数（含外委-离岗实检
     */
    @Column(name = "check_leave_work_staff_real_count")
    private Long checkLeaveWorkStaffRealCount;

    /**
     * 法人代表身份证类型
     * 1、居民身份证；
     * 2、护照；
     * 3、港澳台居民通行证；
     * 4、回乡证；
     * 5、军官证；
     */
    @Column(name = "legal_card_type")
    private Integer legalCardType;

    /**
     * 法人代表身份证
     */
    @Column(name = "legal_card_id")
    private String legalCardId;

    /**
     * 法人代表身份证完整信息。
     * 如果legalCardId被脱敏处理的话，此字段可存储身份证的完整信息。
     */
    @Transient
    private String legalCardIdFull;

    //===================


    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    @Column(name = "data_update_date")
    private Date dataUpdateDate;

}
