package cn.smarthse.modules.health.entity.base.company;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.validation.DataValida;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Table(name = "company_organization")
public class CompanyOrganization implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 上级组织id
     */
    private Long pid;

    /**
     * 组织名称 、部门
     */
    @DataValida(maxLength="32",minLength="1",nullAble=false,name="组织机构名称",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "organization_name")
    private String organizationName;

    /**
     * 层级
     */
    private Byte level;

    /**
     * 组织树路径（个祖先节点以逗号分隔）
     */
    @Column(name = "tree_path")
    private String treePath;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 子节点顺序
     */
    @Column(name = "order_num")
    private Integer orderNum;


    /**
     * 数据来源（1 万达仓)
     */
    @Column(name = "data_source")
    private Byte dataSource;

    /**
     * 数据修改来源（1 万达仓)
     */
    @Column(name = "data_update_source")
    private Byte dataUpdateSource;

    
    /**
     * 部门编码
     */
    private String code;
    
    /**
	 * 是否叶子节点
	 */
    @Transient
	private boolean isLeaf=false;
	
	/**
	 * 是否默认展开
	 */
    @Transient
	private boolean expanded=false;
    
    /**
     * 员工个数
     */
    @Transient
    private Integer staffCount=0;

    /**
     * 是否是新增
     */
    @Transient
    private Boolean newAdd;

    /**
     * 子部门
     */
    private List<CompanyOrganization> children = new ArrayList<>();

    /**
     * 员工信息
     */
    @Transient
    List<StaffWorkRole> staffWorkRoleList = new ArrayList<>();

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取上级组织id
     *
     * @return pid - 上级组织id
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 设置上级组织id
     *
     * @param pid 上级组织id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }

    /**
     * 获取组织名称
     *
     * @return organization_name - 组织名称
     */
    public String getOrganizationName() {
        return organizationName;
    }

    /**
     * 设置组织名称
     *
     * @param organizationName 组织名称
     */
    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName == null ? null : organizationName.trim();
    }

    /**
     * 获取层级
     *
     * @return level - 层级
     */
    public Byte getLevel() {
        return level;
    }

    /**
     * 设置层级
     *
     * @param level 层级
     */
    public void setLevel(Byte level) {
        this.level = level;
    }

    /**
     * 获取组织树路径（个祖先节点以逗号分隔）
     *
     * @return tree_path - 组织树路径（个祖先节点以逗号分隔）
     */
    public String getTreePath() {
        return treePath;
    }

    /**
     * 设置组织树路径（个祖先节点以逗号分隔）
     *
     * @param treePath 组织树路径（个祖先节点以逗号分隔）
     */
    public void setTreePath(String treePath) {
        this.treePath = treePath == null ? null : treePath.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public boolean getIsLeaf() {
		return isLeaf;
	}

	public void setIsLeaf(boolean isLeaf) {
		this.isLeaf = isLeaf;
	}

	public boolean isExpanded() {
		return expanded;
	}

	public void setExpanded(boolean expanded) {
		this.expanded = expanded;
	}

	public Integer getStaffCount() {
		return staffCount;
	}

	public void setStaffCount(Integer staffCount) {
		this.staffCount = staffCount;
	}

	public Integer getOrderNum() {
		return orderNum;
	}

	public void setOrderNum(Integer orderNum) {
		this.orderNum = orderNum;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

    public Boolean getNewAdd() {
        return newAdd;
    }

    public void setNewAdd(Boolean newAdd) {
        this.newAdd = newAdd;
    }

    public Byte getDataSource() {
        return dataSource;
    }

    public void setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
    }

    public Byte getDataUpdateSource() {
        return dataUpdateSource;
    }

    public void setDataUpdateSource(Byte dataUpdateSource) {
        this.dataUpdateSource = dataUpdateSource;
    }

    public List<CompanyOrganization> getChildren() {
        return children;
    }

    public void setChildren(List<CompanyOrganization> children) {
        this.children = children;
    }

    public List<StaffWorkRole> getStaffWorkRoleList() {
        return staffWorkRoleList;
    }

    public void setStaffWorkRoleList(List<StaffWorkRole> staffWorkRoleList) {
        this.staffWorkRoleList = staffWorkRoleList;
    }
    
}