package cn.smarthse.modules.health.entity.base.company;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "company_harm_factor_declare")
public class CompanyHarmFactorDeclare implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 工作名称
     */
    @Column(name = "work_name")
    private String workName;

    /**
     * 申报日期
     */
    @Column(name = "declare_date")
    private Date declareDate;

    /**
     * 申报表电子版
     */
    @Column(name = "declare_file")
    private String declareFile;

    /**
     * 申报原件存放位置
     */
    @Column(name = "declare_file_store_position")
    private String declareFileStorePosition;

    /**
     * 回执电子版
     */
    @Column(name = "feedback_file")
    private String feedbackFile;

    /**
     * 回执原件存放位置
     */
    @Column(name = "feedback_file_store_position")
    private String feedbackFileStorePosition;

    /**
     * 状态（1、存草稿；2、完成)
     */
    private Byte status;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取工作名称
     *
     * @return work_name - 工作名称
     */
    public String getWorkName() {
        return workName;
    }

    /**
     * 设置工作名称
     *
     * @param workName 工作名称
     */
    public void setWorkName(String workName) {
        this.workName = workName == null ? null : workName.trim();
    }

    /**
     * 获取申报日期
     *
     * @return declare_date - 申报日期
     */
    public Date getDeclareDate() {
        return declareDate;
    }

    /**
     * 设置申报日期
     *
     * @param declareDate 申报日期
     */
    public void setDeclareDate(Date declareDate) {
        this.declareDate = declareDate;
    }

    /**
     * 获取申报表电子版
     *
     * @return declare_file - 申报表电子版
     */
    public String getDeclareFile() {
        return declareFile;
    }

    /**
     * 设置申报表电子版
     *
     * @param declareFile 申报表电子版
     */
    public void setDeclareFile(String declareFile) {
        this.declareFile = declareFile == null ? null : declareFile.trim();
    }

    /**
     * 获取申报原件存放位置
     *
     * @return declare_file_store_position - 申报原件存放位置
     */
    public String getDeclareFileStorePosition() {
        return declareFileStorePosition;
    }

    /**
     * 设置申报原件存放位置
     *
     * @param declareFileStorePosition 申报原件存放位置
     */
    public void setDeclareFileStorePosition(String declareFileStorePosition) {
        this.declareFileStorePosition = declareFileStorePosition == null ? null : declareFileStorePosition.trim();
    }

    /**
     * 获取回执电子版
     *
     * @return feedback_file - 回执电子版
     */
    public String getFeedbackFile() {
        return feedbackFile;
    }

    /**
     * 设置回执电子版
     *
     * @param feedbackFile 回执电子版
     */
    public void setFeedbackFile(String feedbackFile) {
        this.feedbackFile = feedbackFile == null ? null : feedbackFile.trim();
    }

    /**
     * 获取回执原件存放位置
     *
     * @return feedback_file_store_position - 回执原件存放位置
     */
    public String getFeedbackFileStorePosition() {
        return feedbackFileStorePosition;
    }

    /**
     * 设置回执原件存放位置
     *
     * @param feedbackFileStorePosition 回执原件存放位置
     */
    public void setFeedbackFileStorePosition(String feedbackFileStorePosition) {
        this.feedbackFileStorePosition = feedbackFileStorePosition == null ? null : feedbackFileStorePosition.trim();
    }

    /**
     * 获取状态（1、存草稿；2、完成)
     *
     * @return status - 状态（1、存草稿；2、完成)
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置状态（1、存草稿；2、完成)
     *
     * @param status 状态（1、存草稿；2、完成)
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}