package cn.smarthse.modules.health.entity.base.company;

import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 职能机构人员-操作记录(CompanyFunctionalOrganizationMemberLog)表实体类
 *
 * @author 曾华川
 * @since 2024-04-25 16:18:06
 */
@Table(name = "company_functional_organization_member_log")
@Data
public class CompanyFunctionalOrganizationMemberLog implements Serializable {

    private static final long serialVersionUID = 5604624572606563852L;
    /**
     * id
     */
    @Id
    private Long id;

    private Long cid;

    /**
     * company_functional_organization表id
     */
    private Long companyFunctionalOrganizationId;

    /**
     * company_functional_organization_member表id
     */
    private Long memberId;

    /**
     * 人员姓名
     */
    private String staffName;

    /**
     * 操作类型（1-新增，2-编辑，3-删除）
     */
    private Byte type;

    /**
     * 变更字段（在人员信息的证书变更时值为 cert_id）
     */
    private String changeField;

    /**
     * 变更前
     */
    private String beforeChange;

    /**
     * 变更后
     */
    private String afterChange;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    /**
     * 创建人id
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人id
     */
    private Long updateBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 是否为 基础信息变更记录（true-是）
     */
    private Boolean isBase;
}

