package cn.smarthse.modules.health.entity.base.company;

import cn.smarthse.modules.health.entity.work.certificate.CertificateFiles;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName CompanyFunctionalOrganizationMemberCert
 * @Description 职能机构人员关联的证书信息
 * @Author 曾华川
 * @Date 2024年05月27日 11:21
 **/
@Data
@Table(name = "company_functional_organization_member_cert")
public class CompanyFunctionalOrganizationMemberCert implements Serializable {

    private static final long serialVersionUID = -4868110811853922597L;
    @Id
    private Long id;

    private Long cid;

    /**
     * company_functional_organization_member表id
     */
    private Long memberId;

    /**
     * certificate_staff_detail表id
     */
    private Long certId;

    private Boolean isValid;

    private Long createBy;

    private Date createDate;

    private Long updateBy;

    private Date updateDate;

    @Transient
    private String staffName;

    @Transient
    private String certNo;

    /**
     * 取证时间
     */
    @Transient
    private Date certCreateDate;

    /**
     * 有效期
     */
    @Transient
    private Date validityDate;

    /**
     * 证书类型（12-负责人，13-职业健康管理人员）
     */
    @Transient
    private Integer certType;

    /**
     * 证书状态（0-过期，1-有效）
     */
    @Transient
    private Integer certState;

    @Transient
    private List<CertificateFiles> files;
}
