package cn.smarthse.modules.health.entity.base.company;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.validation.DataValida;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.enums.company.FunOrgMemberDutyEnum;
import cn.smarthse.modules.health.enums.company.FunOrgMemberTypeEnum;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "company_functional_organization_member")
public class CompanyFunctionalOrganizationMember implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 企业ID列表
     */
    @Transient
    private List<Long> cidList;

    /**
     * 人员类型范围，参考字段：orgStaffType（若多个，逗号分隔）
     */
    @Transient
    private String orgStaffTypes;

    /**
     * 职能机构ID
     */
    @DataValida(min="1",nullAble=false,name="职能机构ID",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "company_functional_organization_id")
    private Long companyFunctionalOrganizationId;

    /**
     * 人员信息ID
     */
    @DataValida(min="0",nullAble=false,name="姓名",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 人员姓名（冗余）
     */
    @Column(name = "staff_name")
    private String staffName;

   /**
    * 成员学历
    */
    @Column(name = "staff_education")
    private String staffEducation;

    /**
     * 成员专业
     */
    @Column(name = "staff_major")
    private String staffMajor;

    /**
     * 成员部门/车间
     */
    @Column(name = "staff_organization")
    private String staffOrganization;

    /**
     * 成员公司职务
     */
    @Column(name = "staff_job_title")
    private String staffJobTitle;

    /**
     * 成员手机
     */
    @Column(name = "staff_mobile")
    private String staffMobile;

    /**
     * 上级职能机构人员
     */
    private Long pid;

    /**
     * 职务（组长、副组长、成员）
     */
    private Byte duty;

    @Transient
    private String dutyName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 成员类型（1-专职、2-兼职）
     */
    @Column(name = "member_type")
    private Byte memberType;

    @Transient
    private String memberTypeName;

    /**
     * 成员聘任文书
     */
    @Column(name = "employ_file")
    private String employFile;

    /**
     * 职业卫生管理培训合格证书
     * (改为从证书管理模块取信息)
     */
    @Column(name = "occ_health_certificate")
//    @Transient
    private String occHealthCertificate;

    /**
	 * 专/兼职人员任聘文书
	 */
    @Transient
	private List<SysFileModel> employFiles;

    /**
     * 专/兼职人员任聘文书名称
     */
    @Transient
    private String employFileNames;

	/**
	 * 培训合格证书
	 */
    @Transient
	private List<SysFileModel> occHealthCertificates;

    /**
     * 培训合格证书名称
     */
    @Transient
    private String occHealthCertificateNames;

    /**
     * 员工信息
     */
    @Transient
//    private StaffInfo staffInfo;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 人员类型（1-企业负责人，2-职业卫生管理人员），可多选
     */
    @Column(name = "org_staff_type")
    private String orgStaffType;
    private List<String> orgStaffTypeList;

    /**
     * 是否为合规企业管理惹人员
     */
    @Column
    private Boolean isComplianceManager;

    /**
     * 负责人证书状态（0-无效，1-有效，2-无证书，3- /）
     */
    @Transient
    private Integer leaderCert;
    /**
     * 管理人员证书状态（0-无效，1-有效，2-无证书，3- /）
     */
    @Transient
    private Integer managerCert;
    /**
     * 负责人证书来源
     */
    @Transient
    private Integer leaderDataSource;
    /**
     * 管理人员证书来源
     */
    @Transient
    private Integer managerDataSource;

    public String getOrgStaffType() {
        return orgStaffType;
    }

    public void setOrgStaffType(String orgStaffType) {
        this.orgStaffType = orgStaffType;
    }

    public List<String> getOrgStaffTypeList() {
        return orgStaffTypeList;
    }

    public void setOrgStaffTypeList(List<String> orgStaffTypeList) {
        this.orgStaffTypeList = orgStaffTypeList;
    }

    public Boolean getIsComplianceManager() {
        return isComplianceManager;
    }

    public void setIsComplianceManager(Boolean complianceManager) {
        isComplianceManager = complianceManager;
    }

    public Integer getLeaderCert() {
        return leaderCert;
    }

    public void setLeaderCert(Integer leaderCert) {
        this.leaderCert = leaderCert;
    }

    public Integer getManagerCert() {
        return managerCert;
    }

    public void setManagerCert(Integer managerCert) {
        this.managerCert = managerCert;
    }

    public Integer getLeaderDataSource() {
        return leaderDataSource;
    }

    public void setLeaderDataSource(Integer leaderDataSource) {
        this.leaderDataSource = leaderDataSource;
    }

    public Integer getManagerDataSource() {
        return managerDataSource;
    }

    public void setManagerDataSource(Integer managerDataSource) {
        this.managerDataSource = managerDataSource;
    }

    /**
     * 学历，显示用
     */
//   @Transient
//   private String education;

    //*********************导出的时候所需的属性***********************/
//    /**
//     * 部门/车间
//     */
//    @Transient
//    private String organization;
//
//    /**
//     * 电话
//     */
//    @Transient
//    private String telepnone;
//
//    /**
//     * 公司职务
//     */
//    @Transient
//    private String jobTitle;
//
//    @Transient
//    private String workPlace;

//    public String getJobTitle() {
//		return jobTitle;
//	}
//
//	public void setJobTitle(String jobTitle) {
//		this.jobTitle = jobTitle;
//	}
//
//	public String getOrganization() {
//		return organization;
//	}
//
//	public void setOrganization(String organization) {
//		this.organization = organization;
//	}
//
//	public String getTelepnone() {
//		return telepnone;
//	}
//
//	public void setTelepnone(String telepnone) {
//		this.telepnone = telepnone;
//	}

	public String getMemberTypeName() {
    	if(this.memberType==null){
    		return null;
    	}
    	for(FunOrgMemberTypeEnum t:FunOrgMemberTypeEnum.values()){
    		if(t.getCode().equals(this.memberType)){
    			return t.getName();
    		}
    	}
		return memberTypeName;
	}

	public List<SysFileModel> getEmployFiles() {
		return employFiles;
	}

	public void setEmployFiles(List<SysFileModel> employFiles) {
		this.employFiles = employFiles;
	}

	public List<SysFileModel> getOccHealthCertificates() {
		return occHealthCertificates;
	}

	public void setOccHealthCertificates(List<SysFileModel> occHealthCertificates) {
		this.occHealthCertificates = occHealthCertificates;
	}

	public void setMemberTypeName(String memberTypeName) {
		this.memberTypeName = memberTypeName;
	}

	public String getDutyName() {
    	if(this.duty == null){
    		return null;
    	}
    	for(FunOrgMemberDutyEnum d:FunOrgMemberDutyEnum.values()){
    		if(d.getCode().equals(duty)){
    			return d.getName();
    		}
    	}
		return dutyName;
	}

	public void setDutyName(String dutyName) {
		this.dutyName = dutyName;
	}

//    public StaffInfo getStaffInfo() {
//		return staffInfo;
//	}
//
//	public void setStaffInfo(StaffInfo staffInfo) {
//		this.staffInfo = staffInfo;
//	}

	private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    public List<Long> getCidList() {
        return cidList;
    }

    public void setCidList(List<Long> cidList) {
        this.cidList = cidList;
    }

    public String getOrgStaffTypes() {
        return orgStaffTypes;
    }

    public void setOrgStaffTypes(String orgStaffTypes) {
        this.orgStaffTypes = orgStaffTypes;
    }

    /**
     * 获取职能机构ID
     *
     * @return company_functional_organization_id - 职能机构ID
     */
    public Long getCompanyFunctionalOrganizationId() {
        return companyFunctionalOrganizationId;
    }

    /**
     * 设置职能机构ID
     *
     * @param companyFunctionalOrganizationId 职能机构ID
     */
    public void setCompanyFunctionalOrganizationId(Long companyFunctionalOrganizationId) {
        this.companyFunctionalOrganizationId = companyFunctionalOrganizationId;
    }

    /**
     * 获取人员信息ID
     *
     * @return staff_id - 人员信息ID
     */
    public Long getStaffId() {
        return staffId;
    }

    /**
     * 设置人员信息ID
     *
     * @param staffId 人员信息ID
     */
    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 获取上级职能机构人员
     *
     * @return pid - 上级职能机构人员
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 设置上级职能机构人员
     *
     * @param pid 上级职能机构人员
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }

    /**
     * 获取职务（组长、副组长、成员）
     *
     * @return duty - 职务（组长、副组长、成员）
     */
    public Byte getDuty() {
        return duty;
    }

    /**
     * 设置职务（组长、副组长、成员）
     *
     * @param duty 职务（组长、副组长、成员）
     */
    public void setDuty(Byte duty) {
        this.duty = duty;
    }

    /**
     * 获取备注
     *
     * @return remark - 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**
     * 获取成员类型（专职、兼职）
     *
     * @return member_type - 成员类型（专职、兼职）
     */
    public Byte getMemberType() {
        return memberType;
    }

    /**
     * 设置成员类型（专职、兼职）
     *
     * @param memberType 成员类型（专职、兼职）
     */
    public void setMemberType(Byte memberType) {
        this.memberType = memberType;
    }

    /**
     * 获取成员聘任文书
     *
     * @return employ_file - 成员聘任文书
     */
    public String getEmployFile() {
        return employFile;
    }

    /**
     * 设置成员聘任文书
     *
     * @param employFile 成员聘任文书
     */
    public void setEmployFile(String employFile) {
        this.employFile = employFile == null ? null : employFile.trim();
    }

    /**
     * 获取职业卫生管理培训合格证书
     *
     * @return occ_health_certificate - 职业卫生管理培训合格证书
     */
    public String getOccHealthCertificate() {
        return occHealthCertificate;
    }

    /**
     * 设置职业卫生管理培训合格证书
     *
     * @param occHealthCertificate 职业卫生管理培训合格证书
     */
    public void setOccHealthCertificate(String occHealthCertificate) {
        this.occHealthCertificate = occHealthCertificate == null ? null : occHealthCertificate.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getStaffName() {
		return staffName;
	}

	public void setStaffName(String staffName) {
		this.staffName = staffName;
	}

//	public String getWorkPlace() {
//		return workPlace;
//	}
//
//	public void setWorkPlace(String workPlace) {
//		this.workPlace = workPlace;
//	}

//	public String getEducation() {
//		return education;
//	}
//
//	public void setEducation(String education) {
//		this.education = education;
//	}

	public String getStaffEducation() {
		return staffEducation;
	}

	public void setStaffEducation(String staffEducation) {
		this.staffEducation = staffEducation;
	}

	public String getStaffMajor() {
		return staffMajor;
	}

	public void setStaffMajor(String staffMajor) {
		this.staffMajor = staffMajor;
	}

	public String getStaffOrganization() {
		return staffOrganization;
	}

	public void setStaffOrganization(String staffOrganization) {
		this.staffOrganization = staffOrganization;
	}

	public String getStaffJobTitle() {
		return staffJobTitle;
	}

	public void setStaffJobTitle(String staffJobTitle) {
		this.staffJobTitle = staffJobTitle;
	}

	public String getStaffMobile() {
		return staffMobile;
	}

	public void setStaffMobile(String staffMobile) {
		this.staffMobile = staffMobile;
	}

	public boolean equals(CompanyFunctionalOrganizationMember member) {
		if(member == null){
			return false;
		}
		boolean isEqual=true;
		if(this.duty==null ){
			if(member.getDuty()!=null){
				return false;
			}
		} else if(!this.duty.equals(member.getDuty())){
			return false;
		}

		if(this.employFile==null ){
			if(member.getEmployFile()!=null){
				return false;
			}
		} else if(!this.employFile.equals(member.getEmployFile())){
			return false;
		}

		if(this.memberType==null ){
			if(member.getMemberType()!=null){
				return false;
			}
		} else if(!this.memberType.equals(member.getMemberType())){
			return false;
		}

		if(this.occHealthCertificate==null ){
			if(member.getOccHealthCertificate()!=null){
				return false;
			}
		} else if(!this.occHealthCertificate.equals(member.getOccHealthCertificate())){
			return false;
		}

		if(this.pid==null ){
			if(member.getPid()!=null){
				return false;
			}
		} else if(!this.pid.equals(member.getPid())){
			return false;
		}

		if(this.remark==null ){
			if(member.getRemark()!=null){
				return false;
			}
		} else if(!this.remark.equals(member.getRemark())){
			return false;
		}

		if(this.staffEducation==null ){
			if(member.getStaffEducation()!=null){
				return false;
			}
		} else if(!this.staffEducation.equals(member.getStaffEducation())){
			return false;
		}

		if(this.staffId==null ){
			if(member.getStaffId()!=null){
				return false;
			}
		} else if(!this.staffId.equals(member.getStaffId())){
			return false;
		}

		if(this.staffJobTitle==null ){
			if(member.getStaffJobTitle()!=null){
				return false;
			}
		} else if(!this.staffJobTitle.equals(member.getStaffJobTitle())){
			return false;
		}

		if(this.staffMajor==null ){
			if(member.getStaffMajor()!=null){
				return false;
			}
		} else if(!this.staffMajor.equals(member.getStaffMajor())){
			return false;
		}

		if(this.staffMobile==null ){
			if(member.getStaffMobile()!=null){
				return false;
			}
		} else if(!this.staffMobile.equals(member.getStaffMobile())){
			return false;
		}

		if(this.staffName==null ){
			if(member.getStaffName()!=null){
				return false;
			}
		} else if(!this.staffName.equals(member.getStaffName())){
			return false;
		}

		if(this.staffOrganization==null ){
			if(member.getStaffOrganization()!=null){
				return false;
			}
		} else if(!this.staffOrganization.equals(member.getStaffOrganization())){
			return false;
		}

		if(this.id==null ){
			if(member.getId()!=null){
				return false;
			}
		} else if(!this.id.equals(member.getId())){
			return false;
		}

		return isEqual;
	}

    public String getEmployFileNames() {
        return employFileNames;
    }

    public void setEmployFileNames(String employFileNames) {
        this.employFileNames = employFileNames;
    }

    public String getOccHealthCertificateNames() {
        return occHealthCertificateNames;
    }

    public void setOccHealthCertificateNames(String occHealthCertificateNames) {
        this.occHealthCertificateNames = occHealthCertificateNames;
    }
}
