package cn.smarthse.modules.health.entity.base.company;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "company_functional_organization")
public class CompanyFunctionalOrganization implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 机构类型（职业卫生、应急救援、辐射安全、自定义）
     */
    // @DataValida(min="1",max="5",nullAble=false,name="机构类型ID",group={Constants.MESSAGE_GROUP_ADD})
    @Column(name = "organization_type")
    private Byte organizationType;

    /**
     * 成立文件（文件id，以逗号分隔）
     */
    @Column(name = "establish_file")
    private String establishFile;
    
    /**
     * 成立文件
     */
    @Transient
    private List<SysFileModel> establishFileList;
    @Transient
    private List<SysFileModel> mainPersonAsFirstleaderProvefilesList;

    /**
     * 机构名称（机构类型）
     */
    // @DataValida(maxLength="32",minLength="1",nullAble=false,name="机构类型",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "organization_name")
    private String organizationName;

    /**
     * 管理部门
     */
    @Column(name = "manage_department")
    private String manageDepartment;

    /**
     * 领导机构名称
     */
    @Column(name = "leader_organization_name")
    private String leaderOrganizationName;

    /**
     * 主要负责人是否担任最高决策者
     */
    @Column(name = "main_person_as_firstleader")
    private Boolean mainPersonAsFirstleader;
    /**
     * 主要负责人是否担任最高决策者 佐证材料 证明
     */
    @Column(name = "main_person_as_firstleader_provefiles")
    private String mainPersonAsFirstleaderProvefiles;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 负责人
     */
    private Long director;
    
    /**
     * 负责人信息
     */
    @Transient
    private StaffInfo directorInfo;
    
    /**
     * 负责人姓名
     */
    @Column(name = "director_name")
    private String directorName;
    
    /**
     * 职能机构架构图
     */
    @Column(name="architecture_diagram")
    private String architectureDiagram;
    
    /**
     * 职能机构架构图文件列表
     */
    @Transient
    private List<SysFileModel> architectureDiagramFiles;
    
    /**
     * 联系电话
     */
    private String telephone;

    private static final long serialVersionUID = 1L;

    public StaffInfo getDirectorInfo() {
		return directorInfo;
	}

	public void setDirectorInfo(StaffInfo directorInfo) {
		this.directorInfo = directorInfo;
	}

	public List<SysFileModel> getArchitectureDiagramFiles() {
		return architectureDiagramFiles;
	}

	public void setArchitectureDiagramFiles(List<SysFileModel> architectureDiagramFiles) {
		this.architectureDiagramFiles = architectureDiagramFiles;
	}

	public Long getDirector() {
		return director;
	}

	public void setDirector(Long director) {
		this.director = director;
	}

	public String getDirectorName() {
		return directorName;
	}

	public void setDirectorName(String directorName) {
		this.directorName = directorName;
	}

	public String getArchitectureDiagram() {
		return architectureDiagram;
	}

	public void setArchitectureDiagram(String architectureDiagram) {
		this.architectureDiagram = architectureDiagram == null?null:architectureDiagram.trim();
	}

	public String getTelephone() {
		return telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone == null?null:telephone.trim();
	}

	/**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取机构类型（职业卫生、应急救援、辐射安全、自定义）
     *
     * @return organization_type - 机构类型（职业卫生、应急救援、辐射安全、自定义）
     */
    public Byte getOrganizationType() {
        return organizationType;
    }

    /**
     * 设置机构类型（职业卫生、应急救援、辐射安全、自定义）
     *
     * @param organizationType 机构类型（职业卫生、应急救援、辐射安全、自定义）
     */
    public void setOrganizationType(Byte organizationType) {
        this.organizationType = organizationType;
    }

    /**
     * 获取成立文件（文件id，以逗号分隔）
     *
     * @return establish_file - 成立文件（文件id，以逗号分隔）
     */
    public String getEstablishFile() {
        return establishFile;
    }

    /**
     * 设置成立文件（文件id，以逗号分隔）
     *
     * @param establishFile 成立文件（文件id，以逗号分隔）
     */
    public void setEstablishFile(String establishFile) {
        this.establishFile = establishFile == null ? null : establishFile.trim();
    }

    /**
     * 获取机构名称（机构类型）
     *
     * @return organization_name - 机构名称（机构类型）
     */
    public String getOrganizationName() {
        return organizationName;
    }

    /**
     * 设置机构名称（机构类型）
     *
     * @param organizationName 机构名称（机构类型）
     */
    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName == null ? null : organizationName.trim();
    }

    /**
     * 获取管理部门
     *
     * @return manage_department - 管理部门
     */
    public String getManageDepartment() {
        return manageDepartment;
    }

    /**
     * 设置管理部门
     *
     * @param manageDepartment 管理部门
     */
    public void setManageDepartment(String manageDepartment) {
        this.manageDepartment = manageDepartment == null ? null : manageDepartment.trim();
    }

    /**
     * 获取领导机构名称
     *
     * @return leader_organization_name - 领导机构名称
     */
    public String getLeaderOrganizationName() {
        return leaderOrganizationName;
    }

    /**
     * 设置领导机构名称
     *
     * @param leaderOrganizationName 领导机构名称
     */
    public void setLeaderOrganizationName(String leaderOrganizationName) {
        this.leaderOrganizationName = leaderOrganizationName == null ? null : leaderOrganizationName.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public List<SysFileModel> getEstablishFileList() {
		return establishFileList;
	}

	public void setEstablishFileList(List<SysFileModel> establishFileList) {
		this.establishFileList = establishFileList;
	}

    public Boolean getMainPersonAsFirstleader() {
        return mainPersonAsFirstleader;
    }

    public void setMainPersonAsFirstleader(Boolean mainPersonAsFirstleader) {
        this.mainPersonAsFirstleader = mainPersonAsFirstleader;
    }

    public String getMainPersonAsFirstleaderProvefiles() {
        return mainPersonAsFirstleaderProvefiles;
    }

    public void setMainPersonAsFirstleaderProvefiles(String mainPersonAsFirstleaderProvefiles) {
        this.mainPersonAsFirstleaderProvefiles = mainPersonAsFirstleaderProvefiles;
    }

    public List<SysFileModel> getMainPersonAsFirstleaderProvefilesList() {
        return mainPersonAsFirstleaderProvefilesList;
    }

    public void setMainPersonAsFirstleaderProvefilesList(List<SysFileModel> mainPersonAsFirstleaderProvefilesList) {
        this.mainPersonAsFirstleaderProvefilesList = mainPersonAsFirstleaderProvefilesList;
    }
}