package cn.smarthse.modules.health.entity.base.company;


import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

@Table(name = "company_base_info")
public @Data class CompanyBaseInfo implements Serializable {
    @Id
    private Long id;

    private Long cid;

    /**
     * 省编号
     */
    @Column(name = "province_id")
    private Long provinceId;

    /**
     * 省名称
     */
    @Column(name = "province_name")
    private String provinceName;

    /**
     * 市编号
     */
    @Column(name = "city_id")
    private Long cityId;

    /**
     * 市名称
     */
    @Column(name = "city_name")
    private String cityName;

    /**
     * 区域ID
     */
    @Column(name = "area_id")
    private Long areaId;

    /**
     * 区域名称
     */
    @Column(name = "area_name")
    private String areaName;

    /**
     * 乡镇街道编号
     */
    @Column(name = "street_id")
    private Long streetId;

    /**
     * 乡镇街道名称
     */
    @Column(name = "street_name")
    private String streetName;

    /**
     * 行政区域详情：原始存放的编号
     */
    @Column(name = "area_detail_id")
    private Long areaDetailId;

    /**
     * 行政区域详情：省市区县街道
     */
    @Column(name = "area_detail_name")
    private String areaDetailName;

    /**
     * 行政区域 层级
     */
    @Column(name = "area_level")
    private Byte areaLevel;

    /**
     * fullname企业名称
     */
    private String name;

    /**
     * 企业名称简称
     */
    @Column(name = "short_name")
    private String shortName;

    /**
     * 上属公司（或主管单位）
     */
    @Column(name = "father_dept")
    private String fatherDept;

    /**
     * 成立时间
     */
    @Column(name = "setting_time")
    private Date settingTime;

    /**
     * corp_cc统一社会信用代码（此处该代码用于显示，由平台申请企业认证赋予数据）
     */
    @Column(name = "unified_social_cc")
    private String unifiedSocialCc;

    /**
     * corp_tel 企业联系电话
     */
    @Column(name = "company_contact_tel")
    private String companyContactTel;

    /**
     * corp_email 企业电子邮箱
     */
    @Column(name = "company_contact_email")
    private String companyContactEmail;

    /**
     * 企业传真
     */
    @Column(name = "company_contact_fax")
    private String companyContactFax;

    /**
     * 企业注册地详址
     */
    @Column(name = "register_address")
    private String registerAddress;

    /**
     * 企业注册地址邮编
     */
    @Column(name = "register_post")
    private String registerPost;

    /**
     * corp_address 企业通讯地址
     */
    @Column(name = "company_postal_adress")
    private String companyPostalAdress;

    /**
     * 工作产所地址（工作场所地址）
     */
    @Column(name = "work_address")
    private String workAddress;

    /**
     * 注册类型
     */
    @Column(name = "register_type")
    private Long registerType;

    /**
     * 注册类型名称
     */
    @Column(name = "register_type_name")
    private String registerTypeName;

    /**
     * corp_type 行业分类（sys_param.param_code）
     */
    @Column(name = "industry_category")
    private Long industryCategory;

    /**
     * corp_type 行业分类名称（sys_param.param_code）
     */
    @Column(name = "industry_category_name")
    private String industryCategoryName;

    /**
     * 职业病危害风险分类(0-严重、1-较重、2-一般)
     */
    @Column(name = "occupational_risk_classify")
    private Integer occupationalRiskClassify;

    /**
     * 在岗职工人数
     */
    @Column(name = "staff_count")
    private Integer staffCount;

    /**
     * 接害人数（不重复计）
     */
    @Column(name = "pickup_count")
    private Integer pickupCount;

    /**
     * 主营营业收入（万元）
     */
    @Column(name = "main_opera_income")
    private BigDecimal mainOperaIncome;

    /**
     * 注册资本
     */
    @Column(name = "register_apital")
    private BigDecimal registerApital;

    /**
     * 企业规模
     */
    private String scale;

    /**
     * 企业规模(名称）
     */
    @Column(name = "scale_name")
    private String scaleName;

    /**
     * 企业年度产值
     */
    @Column(name = "year_assets")
    private BigDecimal yearAssets;

    /**
     * 企业资产总值
     */
    @Column(name = "total_assets")
    private BigDecimal totalAssets;

    /**
     * 法人代表姓名
     */
    @Column(name = "legal_name")
    private String legalName;

    /**
     * 法人代表联系电话
     */
    @Column(name = "legal_tel")
    private String legalTel;

    /**
     * 化学事故应急咨询服务电话
     */
    @Column(name = "chemical_emergency_phone")
    private String chemicalEmergencyPhone;

    /**
     * 职业卫生负责人
     */
    @Column(name = "occ_leader_sid")
    private Long occLeaderSid;

    /**
     * 职业卫生负责人联系电话
     */
    @Column(name = "occ_leader_tel")
    private String occLeaderTel;

    /**
     * 监管隐藏的企业
     */
    @Column(name = "supervise_is_hide")
    private Boolean superviseIsHide;

    /**
     * 监管删除的企业
     */
    @Column(name = "supervise_is_del")
    private Boolean superviseIsDel;



    private Boolean isBest;
    private Date bestUpdateTime;
    /**
     * 企业logo url 地址
     */
    @Column(name = "logo_file_url")
    private String logoFileUrl;

    /**
     * 经营状态：存续，吊销
     */
    @Column(name = "operation_status")
    private String operationStatus;

    /**
     * 申报系统名称
     */
    @Column(name = "report_company_name")
    private String reportCompanyName;

    /**
     * 申报日期
     */
    @Column(name = "report_date")
    private Date reportDate;

    /**
     * 申报类型
     */
    @Column(name = "report_type")
    private String reportType;

    /**
     * 平台字段）注册类型(1-企业注册,2-医疗机构注册,3-其他组织机构
     */
    @Column(name = "reg_type")
    private Integer regType;

    /**
     * 平台字段）企业邮箱绑定状态(0-未绑定,1-已发送绑定信息,2-已绑定,3-超时)
     */
    @Column(name = "corp_email_check")
    private Integer corpEmailCheck;

    /**
     * 平台字段）企业编号串扩展(社会统一信代码/登记号/组织代码)
     */
    @Column(name = "corp_cc_extend")
    private String corpCcExtend;

    /**
     * 平台字段）审核结果(0-草稿,1-待审核,2-审核通过,3-审核不通过)
     */
    @Column(name = "check_state")
    private Integer checkState;

    /**
     *  平台字段）审核时间
     */
    @Column(name = "check_date")
    private Date checkDate;

    /**
     * 平台字段）申请人
     */
    @Column(name = "corp_apply_name")
    private String corpApplyName;

    /**
     * 平台字段）申请人手机号
     */
    @Column(name = "corp_apply_mobile")
    private String corpApplyMobile;

    /**
     * 平台字段）证照照片
     */
    @Column(name = "corp_file_url")
    private String corpFileUrl;

    /**
     * 平台字段）头像id
     */
    @Column(name = "logo_file_id")
    private Long logoFileId;

    /**
     * 平台字段）证照照片Id
     */
    @Column(name = "corp_file_id")
    private Long corpFileId;

    /**
     * 平台字段）注册/创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

}