package cn.smarthse.modules.health.entity.base.company;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import cn.smarthse.common.util.validation.DataValida;

@Table(name = "company_area_building_info")
public class CompanyAreaBuildingInfo implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 企业区域ID
     */
    @DataValida(nullAble=false,name="企业区域ID")
    @Column(name = "company_area_id")
    private Long companyAreaId;

    /**
     * 总层数
     */
    @Column(name = "floor_total_num")
    private Integer floorTotalNum;

    /**
     * 地下层数
     */
    @Column(name = "floor_below_num")
    private Integer floorBelowNum;

    /**
     * 地上层数
     */
    @Column(name = "floor_up_num")
    private Integer floorUpNum;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取企业区域ID
     *
     * @return company_area_id - 企业区域ID
     */
    public Long getCompanyAreaId() {
        return companyAreaId;
    }

    /**
     * 设置企业区域ID
     *
     * @param companyAreaId 企业区域ID
     */
    public void setCompanyAreaId(Long companyAreaId) {
        this.companyAreaId = companyAreaId;
    }

    /**
     * 获取总层数
     *
     * @return floor_total_num - 总层数
     */
    public Integer getFloorTotalNum() {
        return floorTotalNum;
    }

    /**
     * 设置总层数
     *
     * @param floorTotalNum 总层数
     */
    public void setFloorTotalNum(Integer floorTotalNum) {
        this.floorTotalNum = floorTotalNum;
    }

    /**
     * 获取地下层数
     *
     * @return floor_below_num - 地下层数
     */
    public Integer getFloorBelowNum() {
        return floorBelowNum;
    }

    /**
     * 设置地下层数
     *
     * @param floorBelowNum 地下层数
     */
    public void setFloorBelowNum(Integer floorBelowNum) {
        this.floorBelowNum = floorBelowNum;
    }

    /**
     * 获取地上层数
     *
     * @return floor_up_num - 地上层数
     */
    public Integer getFloorUpNum() {
        return floorUpNum;
    }

    /**
     * 设置地上层数
     *
     * @param floorUpNum 地上层数
     */
    public void setFloorUpNum(Integer floorUpNum) {
        this.floorUpNum = floorUpNum;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}