package cn.smarthse.modules.health.entity.base.company;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.validation.DataValida;

import javax.persistence.*;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Table(name = "company_area")
public class CompanyArea implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 上级区域id
     */
    private Long pid;

    /**
     * 区域名称
     */
    @DataValida(maxLength="32",minLength="1",nullAble=false,name="区域名称",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "area_name")
    private String areaName;

    /**
     * 层级
     */
    private Byte level;

    /**
     * 结构树路径（个祖先节点以逗号分隔）
     */
    @Column(name = "tree_path")
    private String treePath;
    
    /**
     * 树路径名称
     */
    @Transient
    private String treePathName;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 排序
     */
    private Integer sort;
    
    /**
     * 楼层信息
     */
    @Transient
    private CompanyAreaBuildingInfo buildingInfo;
    
    /**
     * 孩子节点，一般情况下为空，在添加建筑物并设置了层数的时候，会返回孩子节点信息。
     */
    @Transient
    private List<CompanyArea> child = new ArrayList<CompanyArea>();
    
    /**
     * 所有的祖先节点，一帮情况下为空，在获取工作场所列表的时候，手动赋值
     */
    @Transient
    private List<CompanyArea> parents = new ArrayList<CompanyArea>();

    private static final long serialVersionUID = 1L;
    @Transient
    private String sortNo; // 排序编号

    public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public String getTreePathName() {
		return treePathName;
	}

	public void setTreePathName(String treePathName) {
		this.treePathName = treePathName;
	}

	public List<CompanyArea> getParents() {
		return parents;
	}

	public void setParents(List<CompanyArea> parents) {
		this.parents = parents;
	}

	public CompanyAreaBuildingInfo getBuildingInfo() {
		return buildingInfo;
	}

	public void setBuildingInfo(CompanyAreaBuildingInfo buildingInfo) {
		this.buildingInfo = buildingInfo;
	}

	public List<CompanyArea> getChild() {
		return child;
	}

	public void setChild(List<CompanyArea> child) {
		this.child = child;
	}

    public String getSortNo() {
        return sortNo;
    }

    public void setSortNo(String sortNo) {
        this.sortNo = sortNo;
    }

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取上级区域id
     *
     * @return pid - 上级区域id
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 设置上级区域id
     *
     * @param pid 上级区域id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }

    /**
     * 获取区域名称
     *
     * @return area_name - 区域名称
     */
    public String getAreaName() {
        return areaName;
    }

    /**
     * 设置区域名称
     *
     * @param areaName 区域名称
     */
    public void setAreaName(String areaName) {
        this.areaName = areaName == null ? null : areaName.trim();
    }

    /**
     * 获取层级
     *
     * @return level - 层级
     */
    public Byte getLevel() {
        return level;
    }

    /**
     * 设置层级
     *
     * @param level 层级
     */
    public void setLevel(Byte level) {
        this.level = level;
    }

    /**
     * 获取结构树路径（个祖先节点以逗号分隔）
     *
     * @return tree_path - 结构树路径（个祖先节点以逗号分隔）
     */
    public String getTreePath() {
        return treePath;
    }

    /**
     * 设置结构树路径（个祖先节点以逗号分隔）
     *
     * @param treePath 结构树路径（个祖先节点以逗号分隔）
     */
    public void setTreePath(String treePath) {
        this.treePath = treePath == null ? null : treePath.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 根据层级和排序号创建该区域 在所有区域中的排序号
     * @param allAreas
     * @param areaId
     * @return
     */
    public static String creteAreaSortNo(List<CompanyArea> allAreas, Long areaId){

        CompanyArea area = getById(allAreas, areaId);
        String sortS = "";
        int sort = 0;
        DecimalFormat decimalFormat = new DecimalFormat("000000"); // int转字符串6位长度，不足的前面补0
        while (area != null){
            sort = area.getSort();
            sortS = decimalFormat.format(sort) + "-"+ sortS;
            area = getById(allAreas, area.getPid()); // 找父级

        }
        return sortS;

    }

    /**
     * 获取区域的treeName
     * @param allAreas
     * @param areaId
     * @return
     */
    public static String createTreeName(List<CompanyArea> allAreas, Long areaId){
        CompanyArea area = getById(allAreas, areaId);
        String s = "";
        while (area != null){
            s = area.getAreaName() + ">"+s;
            area = getById(allAreas, area.getPid()); // 找父级
        }
        return s.substring(0, s.length() -1);
    }

    public static CompanyArea getById(List<CompanyArea> allAreas, Long id){
        for (CompanyArea area : allAreas) {
            if(area.getId().equals(id)){
                return area;
            }
        }
        return null;
    }
}