package cn.smarthse.modules.health.entity.base;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

public class Company implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业名称
     */
    private String name;

    /**
     * 企业名称简称
     */
    @Column(name = "short_name")
    private String shortName;

    /**
     * 申报系统名称
     */
    @Column(name = "report_company_name")
    private String reportCompanyName;

    /**
     * 申报类型
     */
    @Column(name = "report_type")
    private String reportType;

    /**
     * 申报日期
     */
    @Column(name = "report_date")
    private Date reportDate;

    /**
     * 经营状态：存续，吊销
     */
    @Column(name = "operation_status")
    private String operationStatus;

    /**
     * 上属公司（或主管单位）
     */
    @Column(name = "father_dept")
    private String fatherDept;

    /**
     * 成立时间
     */
    @Deprecated
    @Column(name = "setting_time")
    private Date settingTime;

    /**
     * 统一社会信用代码（此处该代码用于显示，由平台申请企业认证赋予数据）
     */
    @Column(name = "unified_social_cc")
    private String unifiedSocialCc;

    /**
     * 企业联系电话
     */
    @Column(name = "company_contact_tel")
    private String companyContactTel;

    /**
     * 企业电子邮箱
     */
    @Column(name = "company_contact_email")
    private String companyContactEmail;

    /**
     * 企业传真
     */
    @Deprecated
    @Column(name = "company_contact_fax")
    private String companyContactFax;

    /**
     * 行政区域区编号(SYS_DISTRICT2.id)
     */
    @Column(name = "area_id")
    private Long areaId;

    /**
     * 企业注册地详址
     */
    @Column(name = "register_address")
    private String registerAddress;

    @Column(name = "register_address_region_id")
    protected Long registerAddressRegionId;

    /**
     * 企业注册地址邮编
     */
    @Deprecated
    @Column(name = "register_post")
    private String registerPost;

    /**
     * 企业通讯地址
     */
    @Column(name = "company_postal_adress")
    private String companyPostalAdress;

    /**
     * 工作产所地址（工作场所地址）
     */
    @Column(name = "work_address")
    private String workAddress;

    /**
     * 注册类型
     */
    @Column(name = "register_type")
    private Long registerType;

    /**
     * 行业分类（sys_param.id）
     */
    @Column(name = "industry_category")
    private Long industryCategory;

    /**
     * 职业病危害风险分类(0-严重、1-较重、2-一般)
     */
    @Column(name = "occupational_risk_classify")
    private Byte occupationalRiskClassify;

    /**
     * 接害人数（不重复计）
     */
    @Column(name = "pickup_count")
    private Integer pickupCount;

    /**
     * 在岗职工人数
     */
    @Column(name = "staff_count")
    private Integer staffCount;

    /**
     * 主营营业收入（万元）
     */
    @Column(name = "main_opera_income")
    private BigDecimal mainOperaIncome;


    /**
     * 注册资本
     */
    @Deprecated
    @Column(name = "register_capital")
    private BigDecimal registerCapital;

    /**
     * 企业规模
     */
    private String scale;

    /**
     * 企业年度产值
     */
    @Deprecated
    @Column(name = "year_assets")
    private BigDecimal yearAssets;

    /**
     * 企业资产总值
     */
    @Deprecated
    @Column(name = "total_assets")
    private BigDecimal totalAssets;

    /**
     * 法人代表姓名
     */
    @Column(name = "legal_name")
    private String legalName;

    /**
     * 法人代表联系电话
     */
    @Column(name = "legal_tel")
    private String legalTel;

    /**
     * 化学事故应急咨询服务电话
     */
    @Column(name = "chemical_emergency_phone")
    private String chemicalEmergencyPhone;

    /**
     * 职业卫生负责人
     */
    @Column(name = "occ_leader_sid")
    @Deprecated
    private Long occLeaderSid;

    /**
     * 企业logo 文件id
     */
    @Column(name = "logo_file_url")
    private String logoFileUrl;
    /**
     * 职业卫生负责人联系电话
     */
    @Column(name = "occ_leader_tel")
    @Deprecated
    private String occLeaderTel;


    /**
     * 企业主要负责人
     */
    @Column(name = "main_leader_name")
    private String mainLeaderName;
    /**
     * 负责人手机号码
     */
    @Column(name = "mainLeaderTel")
    private String mainLeaderTel;
    /**
     * 职业卫生管理人员
     */
    @Column(name = "occ_manager_name")
    private String occManagerName;
    /**
     * ְ管理人员手机号码
     */
    @Column(name = "occ_manager_tel")
    private String occManagerTel;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 处罚次数
     */
    private Integer punishNum;
    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业名称
     *
     * @return name - 企业名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设置企业名称
     *
     * @param name 企业名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 获取企业名称简称
     *
     * @return short_name - 企业名称简称
     */
    public String getShortName() {
        if (StringUtils.isEmpty(shortName)) {
            return this.name;
        }
        return shortName;
    }

    /**
     * 设置企业名称简称
     *
     * @param shortName 企业名称简称
     */
    public void setShortName(String shortName) {
        this.shortName = shortName == null ? null : shortName.trim();
    }

    /**
     * 获取上属公司（或主管单位）
     *
     * @return father_dept - 上属公司（或主管单位）
     */
    public String getFatherDept() {
        return fatherDept;
    }

    /**
     * 设置上属公司（或主管单位）
     *
     * @param fatherDept 上属公司（或主管单位）
     */
    public void setFatherDept(String fatherDept) {
        this.fatherDept = fatherDept == null ? null : fatherDept.trim();
    }

    /**
     * 获取成立时间
     *
     * @return setting_time - 成立时间
     */
    public Date getSettingTime() {
        return settingTime;
    }

    /**
     * 设置成立时间
     *
     * @param settingTime 成立时间
     */
    public void setSettingTime(Date settingTime) {
        this.settingTime = settingTime;
    }

    /**
     * 获取统一社会信用代码（此处该代码用于显示，由平台申请企业认证赋予数据）
     *
     * @return unified_social_cc - 统一社会信用代码（此处该代码用于显示，由平台申请企业认证赋予数据）
     */
    public String getUnifiedSocialCc() {
        return unifiedSocialCc;
    }

    /**
     * 设置统一社会信用代码（此处该代码用于显示，由平台申请企业认证赋予数据）
     *
     * @param unifiedSocialCc 统一社会信用代码（此处该代码用于显示，由平台申请企业认证赋予数据）
     */
    public void setUnifiedSocialCc(String unifiedSocialCc) {
        this.unifiedSocialCc = unifiedSocialCc == null ? null : unifiedSocialCc.trim();
    }

    /**
     * 获取企业联系电话
     *
     * @return company_contact_tel - 企业联系电话
     */
    public String getCompanyContactTel() {
        return companyContactTel;
    }

    /**
     * 设置企业联系电话
     *
     * @param companyContactTel 企业联系电话
     */
    public void setCompanyContactTel(String companyContactTel) {
        this.companyContactTel = companyContactTel == null ? null : companyContactTel.trim();
    }

    /**
     * 获取企业电子邮箱
     *
     * @return company_contact_email - 企业电子邮箱
     */
    public String getCompanyContactEmail() {
        return companyContactEmail;
    }

    /**
     * 设置企业电子邮箱
     *
     * @param companyContactEmail 企业电子邮箱
     */
    public void setCompanyContactEmail(String companyContactEmail) {
        this.companyContactEmail = companyContactEmail == null ? null : companyContactEmail.trim();
    }

    public Long getRegisterAddressRegionId() {
        return registerAddressRegionId;
    }

    public void setRegisterAddressRegionId(Long registerAddressRegionId) {
        this.registerAddressRegionId = registerAddressRegionId;
    }

    /**
     * 获取企业传真
     *
     * @return company_contact_fax - 企业传真
     */
    public String getCompanyContactFax() {
        return companyContactFax;
    }

    /**
     * 设置企业传真
     *
     * @param companyContactFax 企业传真
     */
    public void setCompanyContactFax(String companyContactFax) {
        this.companyContactFax = companyContactFax == null ? null : companyContactFax.trim();
    }

    /**
     * 获取行政区域区编号(SYS_DISTRICT2.id)
     *
     * @return area_id - 行政区域区编号(SYS_DISTRICT2.id)
     */
    public Long getAreaId() {
        return areaId;
    }

    /**
     * 设置行政区域区编号(SYS_DISTRICT2.id)
     *
     * @param areaId 行政区域区编号(SYS_DISTRICT2.id)
     */
    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    /**
     * 获取企业注册地详址
     *
     * @return register_address - 企业注册地详址
     */
    public String getRegisterAddress() {
        return registerAddress;
    }

    /**
     * 设置企业注册地详址
     *
     * @param registerAddress 企业注册地详址
     */
    public void setRegisterAddress(String registerAddress) {
        this.registerAddress = registerAddress == null ? null : registerAddress.trim();
    }

    /**
     * 获取企业注册地址邮编
     *
     * @return register_post - 企业注册地址邮编
     */
    public String getRegisterPost() {
        return registerPost;
    }

    /**
     * 设置企业注册地址邮编
     *
     * @param registerPost 企业注册地址邮编
     */
    public void setRegisterPost(String registerPost) {
        this.registerPost = registerPost == null ? null : registerPost.trim();
    }

    /**
     * 获取企业通讯地址
     *
     * @return company_postal_adress - 企业通讯地址
     */
    public String getCompanyPostalAdress() {
        return companyPostalAdress;
    }

    /**
     * 设置企业通讯地址
     *
     * @param companyPostalAdress 企业通讯地址
     */
    public void setCompanyPostalAdress(String companyPostalAdress) {
        this.companyPostalAdress = companyPostalAdress == null ? null : companyPostalAdress.trim();
    }

    /**
     * 获取工作产所地址（工作场所地址）
     *
     * @return work_address - 工作产所地址（工作场所地址）
     */
    public String getWorkAddress() {
        return workAddress;
    }

    /**
     * 设置工作产所地址（工作场所地址）
     *
     * @param workAddress 工作产所地址（工作场所地址）
     */
    public void setWorkAddress(String workAddress) {
        this.workAddress = workAddress == null ? null : workAddress.trim();
    }

    /**
     * 获取注册类型
     *
     * @return register_type - 注册类型
     */
    public Long getRegisterType() {
        return registerType;
    }

    /**
     * 设置注册类型
     *
     * @param registerType 注册类型
     */
    public void setRegisterType(Long registerType) {
        this.registerType = registerType;
    }

    /**
     * 获取行业分类（sys_param.id）
     *
     * @return industry_category - 行业分类（sys_param.id）
     */
    public Long getIndustryCategory() {
        return industryCategory;
    }

    /**
     * 设置行业分类（sys_param.id）
     *
     * @param industryCategory 行业分类（sys_param.id）
     */
    public void setIndustryCategory(Long industryCategory) {
        this.industryCategory = industryCategory;
    }

    /**
     * 获取职业病危害风险分类(0-严重、1-较重、2-一般)
     *
     * @return occupational_risk_classify - 职业病危害风险分类(0-严重、1-较重、2-一般)
     */
    public Byte getOccupationalRiskClassify() {
        return occupationalRiskClassify;
    }

    /**
     * 设置职业病危害风险分类(0-严重、1-较重、2-一般)
     *
     * @param occupationalRiskClassify 职业病危害风险分类(0-严重、1-较重、2-一般)
     */
    public void setOccupationalRiskClassify(Byte occupationalRiskClassify) {
        this.occupationalRiskClassify = occupationalRiskClassify;
    }

    /**
     * 获取接害人数（不重复计）
     *
     * @return pickup_count - 接害人数（不重复计）
     */
    public Integer getPickupCount() {
        return pickupCount;
    }

    /**
     * 设置接害人数（不重复计）
     *
     * @param pickupCount 接害人数（不重复计）
     */
    public void setPickupCount(Integer pickupCount) {
        this.pickupCount = pickupCount;
    }

    /**
     * 获取注册资本
     *
     * @return register_capital - 注册资本
     */
    public BigDecimal getRegisterCapital() {
        return registerCapital;
    }

    /**
     * 设置注册资本
     *
     * @param registerCapital 注册资本
     */
    public void setRegisterCapital(BigDecimal registerCapital) {
        this.registerCapital = registerCapital;
    }

    /**
     * 获取企业规模
     *
     * @return scale - 企业规模
     */
    public String getScale() {
        return scale;
    }

    /**
     * 设置企业规模
     *
     * @param scale 企业规模
     */
    public void setScale(String scale) {
        this.scale = scale == null ? null : scale.trim();
    }

    /**
     * 获取企业年度产值
     *
     * @return year_assets - 企业年度产值
     */
    public BigDecimal getYearAssets() {
        return yearAssets;
    }

    /**
     * 设置企业年度产值
     *
     * @param yearAssets 企业年度产值
     */
    public void setYearAssets(BigDecimal yearAssets) {
        this.yearAssets = yearAssets;
    }

    /**
     * 获取企业资产总值
     *
     * @return total_assets - 企业资产总值
     */
    public BigDecimal getTotalAssets() {
        return totalAssets;
    }

    /**
     * 设置企业资产总值
     *
     * @param totalAssets 企业资产总值
     */
    public void setTotalAssets(BigDecimal totalAssets) {
        this.totalAssets = totalAssets;
    }

    /**
     * 获取法人代表姓名
     *
     * @return legal_name - 法人代表姓名
     */
    public String getLegalName() {
        return StringEscapeUtils.unescapeHtml(legalName);
    }

    /**
     * 设置法人代表姓名
     *
     * @param legalName 法人代表姓名
     */
    public void setLegalName(String legalName) {
        this.legalName = legalName == null ? null : legalName.trim();
    }

    /**
     * 获取法人代表联系电话
     *
     * @return legal_tel - 法人代表联系电话
     */
    public String getLegalTel() {
        return legalTel;
    }

    /**
     * 设置法人代表联系电话
     *
     * @param legalTel 法人代表联系电话
     */
    public void setLegalTel(String legalTel) {
        this.legalTel = legalTel == null ? null : legalTel.trim();
    }

    /**
     * 获取化学事故应急咨询服务电话
     *
     * @return chemical_emergency_phone - 化学事故应急咨询服务电话
     */
    public String getChemicalEmergencyPhone() {
        return chemicalEmergencyPhone;
    }

    /**
     * 设置化学事故应急咨询服务电话
     *
     * @param chemicalEmergencyPhone 化学事故应急咨询服务电话
     */
    public void setChemicalEmergencyPhone(String chemicalEmergencyPhone) {
        this.chemicalEmergencyPhone = chemicalEmergencyPhone == null ? null : chemicalEmergencyPhone.trim();
    }

    /**
     * 获取职业卫生负责人
     *
     * @return occ_leader_sid - 职业卫生负责人
     */
    public Long getOccLeaderSid() {
        return occLeaderSid;
    }

    /**
     * 设置职业卫生负责人
     *
     * @param occLeaderSid 职业卫生负责人
     */
    public void setOccLeaderSid(Long occLeaderSid) {
        this.occLeaderSid = occLeaderSid;
    }

    /**
     * 获取职业卫生负责人联系电话
     *
     * @return occ_leader_tel - 职业卫生负责人联系电话
     */
    public String getOccLeaderTel() {
        return occLeaderTel;
    }

    /**
     * 设置职业卫生负责人联系电话
     *
     * @param occLeaderTel 职业卫生负责人联系电话
     */
    public void setOccLeaderTel(String occLeaderTel) {
        this.occLeaderTel = occLeaderTel == null ? null : occLeaderTel.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public String getLogoFileUrl() {
        return logoFileUrl;
    }

    public void setLogoFileUrl(String logoFileUrl) {
        this.logoFileUrl = logoFileUrl;
    }

    public Integer getStaffCount() {
        return staffCount;
    }

    public void setStaffCount(Integer staffCount) {
        this.staffCount = staffCount;
    }

    public BigDecimal getMainOperaIncome() {
        return mainOperaIncome;
    }

    public void setMainOperaIncome(BigDecimal mainOperaIncome) {
        this.mainOperaIncome = mainOperaIncome;
    }

    public String getOperationStatus() {
        return operationStatus;
    }

    public void setOperationStatus(String operationStatus) {
        this.operationStatus = operationStatus;
    }

    public String getReportCompanyName() {
        return reportCompanyName;
    }

    public void setReportCompanyName(String reportCompanyName) {
        this.reportCompanyName = reportCompanyName;
    }

    public String getReportType() {
        return reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    public String getMainLeaderName() {
        return StringEscapeUtils.unescapeHtml(mainLeaderName);
    }

    public void setMainLeaderName(String mainLeaderName) {
        this.mainLeaderName = mainLeaderName;
    }

    public String getMainLeaderTel() {
        return mainLeaderTel;
    }

    public void setMainLeaderTel(String mainLeaderTel) {
        this.mainLeaderTel = mainLeaderTel;
    }

    public String getOccManagerName() {
        return StringEscapeUtils.unescapeHtml(occManagerName);
    }

    public void setOccManagerName(String occManagerName) {
        this.occManagerName = occManagerName;
    }

    public String getOccManagerTel() {
        return occManagerTel;
    }

    public void setOccManagerTel(String occManagerTel) {
        this.occManagerTel = occManagerTel;
    }

    public Integer getPunishNum() {
        return punishNum;
    }

    public void setPunishNum(Integer punishNum) {
        this.punishNum = punishNum;
    }
}