package cn.smarthse.modules.health.entity.base;


import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "business_no")
public class BusinessNo implements Serializable {
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 业务编号
     */
    private String business;

    /**
     * 年月日
     */
    private String day;

    /**
     * 四位序列号
     */
    private Integer no;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

    private static final long serialVersionUID = 1L;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业id
     *
     * @return cid - 企业id
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业id
     *
     * @param cid 企业id
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取业务编号
     *
     * @return business - 业务编号
     */
    public String getBusiness() {
        return business;
    }

    /**
     * 设置业务编号
     *
     * @param business 业务编号
     */
    public void setBusiness(String business) {
        this.business = business == null ? null : business.trim();
    }

    /**
     * 获取年月日
     *
     * @return day - 年月日
     */
    public String getDay() {
        return day;
    }

    /**
     * 设置年月日
     *
     * @param day 年月日
     */
    public void setDay(String day) {
        this.day = day == null ? null : day.trim();
    }

    /**
     * 获取四位序列号
     *
     * @return no - 四位序列号
     */
    public Integer getNo() {
        return no;
    }

    /**
     * 设置四位序列号
     *
     * @param no 四位序列号
     */
    public void setNo(Integer no) {
        this.no = no;
    }

    /**
     * 获取创建时间
     *
     * @return create_time - 创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}