/**
 * 
 */
package cn.smarthse.modules.health.entity.archive.view;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Id;
import javax.persistence.Transient;

import lombok.Data;

/**
 * 《建设项目职业卫生“三同时”档案 视图对象》
 * cid, title, archive_Id, doc_type, doc_param_value, doc_no,doc_version, download_count,
 * doc_check_state, doc_check_date, doc_check_id, doc_check_percent, 
 * doc_generator_state, doc_generator_date, 
 * update_date
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-9-5-下午2:08:48
 */
public @Data class ArchiveView  implements Serializable {
	private static final long serialVersionUID = 232041391051161743L;

	/**
	 * 三同时项目编号/或者年份编号/或者Archive.id
	 */
	@Id
    private Long id;
	
	 /**
    * 企业编号
    */
   private Long cid;
   
   /**
    * 标题
    * doc1:三同时档案则显示三同时项目名
    * doc2~doc5:年份
    * doc6:多个员工姓名
    */
   private String title;
   
   /**
    * 档案主表ID
    */
   private Long archiveId;
   
   /**
    * 档案编号
    */
   private String docNo;
   
   /**
    * 档案类型
           1-三同时
           2-职业卫生管理档案
           3-职业卫生宣传培训档案
           4-职业病危害因素监测与检测评价档案
           5-用人单位职业健康监护管理档案
           6-劳动者个人职业健康监护档案
    */
   private Byte docType;

   /**
    * 档案生成参数值,可用于ids
           1.三同时->参数值:三同时项目ID
           2.职业卫生管理档案>参数值:年份
           3.职业卫生宣传培训档案->参数值:年份
           4-职业病危害因素监测与检测评价档案->参数值:年份
           5-用人单位职业健康监护管理档案->参数:年份
           6-劳动者个人职业健康监护档案->参数:员工Id
           
    */
   private String docParamValue;
   
   /**
    * 项目完成or进行中（三同时档案特有： ）
    */
   private Boolean isFinish;
   
   /**
    * 档案版本(生成取最大+1)
    */
   private Integer docVersion;

   /**
    * 下载次数(冗余)
    */
   private Integer downloadCount;
   
   /**
    * 最后修改时间
    */
   private Date updateDate;
   
   //================自检属性====================
   //doc_check_state, doc_check_date, doc_check_id, doc_check_percent, 
   /**
    * （冗余）自检状态(0-待检测,1-正在自检,2-已完成,3-自检失败)
    */
   private Byte docCheckState;

   /**
    * （冗余）自检时间
    */
   private Date docCheckDate;

   /**
    * （冗余）当前自检Id
    */
   private Long docCheckId;

   /**
    * （冗余）自检完成度,100表示完整,0-99表示不完整
    */
   private Integer docCheckPercent;
   
   
   //=================生成属性================
   
   /**
    * 档案生成结果
    */
   private Byte docGeneratorState;
   
   /**
    * 档案生成时间
    */
   private Date docGeneratorDate;
   
   
   /**
    * 档案数量
    */
   private Integer fileSize = 0;
   
   
   /**
    * 档案文件
    */
   private Long fileId;
   
   
   /**
    * 生成档案id
    */
   private Long archiveFilesId;
}
