package cn.smarthse.modules.health.entity.archive.view;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;

@Table(name = "archive_files_detail_view")
public @Data class ArchiveFilesDetailView implements Serializable {
	
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 档案生成记录id
     */
    @Column(name = "archive_id")
    private Long archiveId;

    /**
     * 档案生成结果Id
     */
    @Column(name = "archive_files_id")
    private Long archiveFilesId;

    /**
     * 性别 0:女 1：男
     */
    private Byte gender;

    /**
     * 姓名
     */
    @Column(name = "real_name")
    private String realName;

    /**
     * 工作编号
     */
    @Column(name = "work_no")
    private String workNo;

    /**
     * 组织名称
     */
    @Column(name = "organization_name")
    private String organizationName;
    
    
    @Transient
    private String paramValue;
    
    
    @Column(name = "archive_generator_id")
    private Long archiveGeneratorId;
    
    @Column(name="staff_id")
    private Long staffId;

    private static final long serialVersionUID = 1L;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业编号
     *
     * @return cid - 企业编号
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业编号
     *
     * @param cid 企业编号
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取档案生成记录id
     *
     * @return archive_id - 档案生成记录id
     */
    public Long getArchiveId() {
        return archiveId;
    }

    /**
     * 设置档案生成记录id
     *
     * @param archiveId 档案生成记录id
     */
    public void setArchiveId(Long archiveId) {
        this.archiveId = archiveId;
    }

    /**
     * 获取档案生成结果Id
     *
     * @return archive_files_id - 档案生成结果Id
     */
    public Long getArchiveFilesId() {
        return archiveFilesId;
    }

    /**
     * 设置档案生成结果Id
     *
     * @param archiveFilesId 档案生成结果Id
     */
    public void setArchiveFilesId(Long archiveFilesId) {
        this.archiveFilesId = archiveFilesId;
    }

    /**
     * 获取性别 0:女 1：男
     *
     * @return gender - 性别 0:女 1：男
     */
    public Byte getGender() {
        return gender;
    }

    /**
     * 设置性别 0:女 1：男
     *
     * @param gender 性别 0:女 1：男
     */
    public void setGender(Byte gender) {
        this.gender = gender;
    }

    /**
     * 获取姓名
     *
     * @return real_name - 姓名
     */
    public String getRealName() {
        return realName;
    }

    /**
     * 设置姓名
     *
     * @param realName 姓名
     */
    public void setRealName(String realName) {
        this.realName = realName == null ? null : realName.trim();
    }

    /**
     * 获取工作编号
     *
     * @return work_no - 工作编号
     */
    public String getWorkNo() {
        return workNo;
    }

    /**
     * 设置工作编号
     *
     * @param workNo 工作编号
     */
    public void setWorkNo(String workNo) {
        this.workNo = workNo == null ? null : workNo.trim();
    }

    /**
     * 获取组织名称
     *
     * @return organization_name - 组织名称
     */
    public String getOrganizationName() {
        return organizationName;
    }

    /**
     * 设置组织名称
     *
     * @param organizationName 组织名称
     */
    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName == null ? null : organizationName.trim();
    }
    
    
}