package cn.smarthse.modules.health.entity.archive.view;

import java.io.Serializable;
import javax.persistence.*;

@Table(name = "archive_check_doc6_user_view")
public class ArchiveCheckDoc6UserView implements Serializable {
	
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 自检Id
     */
    @Column(name = "doc_check_id")
    private Long docCheckId;

    /**
     * 自检项Id
     */
    @Column(name = "doc_check_item_id")
    private Long docCheckItemId;

    /**
     * 自检结果(1:合格,0:不合格)
     */
    @Column(name = "doc_check_result_qualified")
    private Boolean docCheckResultQualified;

    /**
     * 姓名
     */
    @Column(name = "real_name")
    private String realName;

    /**
     * 工作编号
     */
    @Column(name = "work_no")
    private String workNo;

    /**
     * 组织名称
     */
    @Column(name = "organization_name")
    private String organizationName;

    /**
     * 岗位/工种名称
     */
    @Column(name = "work_name")
    private String workName;

    private static final long serialVersionUID = 1L;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业编号
     *
     * @return cid - 企业编号
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业编号
     *
     * @param cid 企业编号
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取自检Id
     *
     * @return doc_check_id - 自检Id
     */
    public Long getDocCheckId() {
        return docCheckId;
    }

    /**
     * 设置自检Id
     *
     * @param docCheckId 自检Id
     */
    public void setDocCheckId(Long docCheckId) {
        this.docCheckId = docCheckId;
    }

    /**
     * 获取自检项Id
     *
     * @return doc_check_item_id - 自检项Id
     */
    public Long getDocCheckItemId() {
        return docCheckItemId;
    }

    /**
     * 设置自检项Id
     *
     * @param docCheckItemId 自检项Id
     */
    public void setDocCheckItemId(Long docCheckItemId) {
        this.docCheckItemId = docCheckItemId;
    }

    /**
     * 获取自检结果(1:合格,0:不合格)
     *
     * @return doc_check_result_qualified - 自检结果(1:合格,0:不合格)
     */
    public Boolean getDocCheckResultQualified() {
        return docCheckResultQualified;
    }

    /**
     * 设置自检结果(1:合格,0:不合格)
     *
     * @param docCheckResultQualified 自检结果(1:合格,0:不合格)
     */
    public void setDocCheckResultQualified(Boolean docCheckResultQualified) {
        this.docCheckResultQualified = docCheckResultQualified;
    }

    /**
     * 获取姓名
     *
     * @return real_name - 姓名
     */
    public String getRealName() {
        return realName;
    }

    /**
     * 设置姓名
     *
     * @param realName 姓名
     */
    public void setRealName(String realName) {
        this.realName = realName == null ? null : realName.trim();
    }

    /**
     * 获取工作编号
     *
     * @return work_no - 工作编号
     */
    public String getWorkNo() {
        return workNo;
    }

    /**
     * 设置工作编号
     *
     * @param workNo 工作编号
     */
    public void setWorkNo(String workNo) {
        this.workNo = workNo == null ? null : workNo.trim();
    }

    /**
     * 获取组织名称
     *
     * @return organization_name - 组织名称
     */
    public String getOrganizationName() {
        return organizationName;
    }

    /**
     * 设置组织名称
     *
     * @param organizationName 组织名称
     */
    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName == null ? null : organizationName.trim();
    }

    /**
     * 获取岗位/工种名称
     *
     * @return work_name - 岗位/工种名称
     */
    public String getWorkName() {
        return workName;
    }

    /**
     * 设置岗位/工种名称
     *
     * @param workName 岗位/工种名称
     */
    public void setWorkName(String workName) {
        this.workName = workName == null ? null : workName.trim();
    }
}