package cn.smarthse.modules.health.entity.archive;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "archive_year")
public @Data class ArchiveYear implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 档案类型
            1-三同时
            2-职业卫生管理档案
            3-职业卫生宣传培训档案
            4-职业病危害因素监测与检测评价档案
            5-用人单位职业健康监护管理档案
            6-劳动者个人职业健康监护档案
     */
    @Column(name = "doc_type")
    private Byte docType;

    /**
     * 档案生成参数值,可用于ids
            1.三同时->参数值:三同时项目ID
            2.职业卫生管理档案>参数值:年份
            3.职业卫生宣传培训档案->参数值:年份
            4-职业病危害因素监测与检测评价档案->参数值:年份
            5-用人单位职业健康监护管理档案->参数:年份
            6-劳动者个人职业健康监护档案->参数:员工Id
            
     */
    @Column(name = "doc_param_value")
    private String docParamValue;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 年度
     */
    @Column(name = "title_year")
    private String titleYear;
    
    
    /*-------------------------------------------------------------------------------------*/
    
    /**
     * 档案主表ID
     */
    @Transient
    private Long archiveId;
    
    /**
     * 档案编号
     */
    @Transient
    private String docNo;
    

    /**
     * 档案版本(生成取最大+1)
     */
    @Transient
    private Integer docVersion;

    /**
     * 下载次数(冗余)
     */
    @Transient
    private Integer downloadCount;
    
    
    /**
     * 档案数量
     */
    @Transient
    private Integer fileSize = 0;
    
    
    /**
     * 档案文件
     */
    @Transient
    private Long fileId;
    
    //================自检属性====================
    //doc_check_state, doc_check_date, doc_check_id, doc_check_percent, 
    /**
     * （冗余）自检状态(0-待检测,1-正在自检,2-已完成,3-自检失败)
     */
    @Transient
    private Byte docCheckState;

    /**
     * （冗余）自检时间
     */
    @Transient
    private Date docCheckDate;

    /**
     * （冗余）当前自检Id
     */
    @Transient
    private Long docCheckId;

    /**
     * （冗余）自检完成度,100表示完整,0-99表示不完整
     */
    @Transient
    private Integer docCheckPercent;
    
    
    //=================生成属性================
    
    /**
     * 档案生成结果
     */
    @Transient
    private Byte docGeneratorState;
    
    /**
     * 档案生成时间
     */
    @Transient
    private Date docGeneratorDate;
    
    
    /**
     * 档案自检
     */
    @Transient
    private ArchiveCheck check;
    
    
    /**
     * 生成档案id
     */
    @Transient
    private Long archiveFilesId;

    
    @Transient
    private Integer checkNum;
    
    private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取档案类型
            1-三同时
            2-职业卫生管理档案
            3-职业卫生宣传培训档案
            4-职业病危害因素监测与检测评价档案
            5-用人单位职业健康监护管理档案
            6-劳动者个人职业健康监护档案
     *
     * @return doc_type - 档案类型
            1-三同时
            2-职业卫生管理档案
            3-职业卫生宣传培训档案
            4-职业病危害因素监测与检测评价档案
            5-用人单位职业健康监护管理档案
            6-劳动者个人职业健康监护档案
     */
    public Byte getDocType() {
        return docType;
    }

    /**
     * 设置档案类型
            1-三同时
            2-职业卫生管理档案
            3-职业卫生宣传培训档案
            4-职业病危害因素监测与检测评价档案
            5-用人单位职业健康监护管理档案
            6-劳动者个人职业健康监护档案
     *
     * @param docType 档案类型
            1-三同时
            2-职业卫生管理档案
            3-职业卫生宣传培训档案
            4-职业病危害因素监测与检测评价档案
            5-用人单位职业健康监护管理档案
            6-劳动者个人职业健康监护档案
     */
    public void setDocType(Byte docType) {
        this.docType = docType;
    }

    /**
     * 获取档案生成参数值,可用于ids
            1.三同时->参数值:三同时项目ID
            2.职业卫生管理档案>参数值:年份
            3.职业卫生宣传培训档案->参数值:年份
            4-职业病危害因素监测与检测评价档案->参数值:年份
            5-用人单位职业健康监护管理档案->参数:年份
            6-劳动者个人职业健康监护档案->参数:员工Id
            
     *
     * @return doc_param_value - 档案生成参数值,可用于ids
            1.三同时->参数值:三同时项目ID
            2.职业卫生管理档案>参数值:年份
            3.职业卫生宣传培训档案->参数值:年份
            4-职业病危害因素监测与检测评价档案->参数值:年份
            5-用人单位职业健康监护管理档案->参数:年份
            6-劳动者个人职业健康监护档案->参数:员工Id
            
     */
    public String getDocParamValue() {
        return docParamValue;
    }

    /**
     * 设置档案生成参数值,可用于ids
            1.三同时->参数值:三同时项目ID
            2.职业卫生管理档案>参数值:年份
            3.职业卫生宣传培训档案->参数值:年份
            4-职业病危害因素监测与检测评价档案->参数值:年份
            5-用人单位职业健康监护管理档案->参数:年份
            6-劳动者个人职业健康监护档案->参数:员工Id
            
     *
     * @param docParamValue 档案生成参数值,可用于ids
            1.三同时->参数值:三同时项目ID
            2.职业卫生管理档案>参数值:年份
            3.职业卫生宣传培训档案->参数值:年份
            4-职业病危害因素监测与检测评价档案->参数值:年份
            5-用人单位职业健康监护管理档案->参数:年份
            6-劳动者个人职业健康监护档案->参数:员工Id
            
     */
    public void setDocParamValue(String docParamValue) {
        this.docParamValue = docParamValue == null ? null : docParamValue.trim();
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取年度
     *
     * @return title_year - 年度
     */
    public String getTitleYear() {
        return titleYear;
    }

    /**
     * 设置年度
     *
     * @param titleYear 年度
     */
    public void setTitleYear(String titleYear) {
        this.titleYear = titleYear == null ? null : titleYear.trim();
    }
}