package cn.smarthse.modules.health.entity.archive;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《档案生成调度表》
 * 需要生成档案任务.FilesGeneratorJob加载此数据表,根据状态去队列生成关联查
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-9-1-上午10:42:50
 */
@Table(name = "archive_generator")
public @Data class ArchiveGenerator implements Serializable {
	private static final long serialVersionUID = -6050803942326662232L;

	@Id
	@Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 档案主表Id
     */
    @Column(name = "archive_id")
    private Long archiveId;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 档案编号
     */
    @Column(name = "doc_no")
    private String docNo;
    
    /**
     * 档案类型
            1-三同时
            2-职业卫生管理档案
            3-职业卫生宣传培训档案
            4-职业病危害因素监测与检测评价档案
            5-用人单位职业健康监护管理档案
            6-劳动者个人职业健康监护档案
     */
    @Column(name = "doc_type")
    private Byte docType;

    /**
     * 档案生成参数值,可用于ids
            1.三同时->参数值:三同时项目ID
            2.职业卫生管理档案>参数值:年份
            3.职业卫生宣传培训档案->参数值:年份
            4-职业病危害因素监测与检测评价档案->参数值:年份
            5-用人单位职业健康监护管理档案->参数:年份
            6-劳动者个人职业健康监护档案->参数:员工Id
            
     */
    @Column(name = "doc_param_value")
    private String docParamValue;

    /**
     * 生成状态(0-待生成,1-正在生成,2-已生成3-生成失败?)
     * @see cn.smarthse.modules.health.enums.archive.ArchiveGeneratorState
     */
    @Column(name = "generator_state")
    private Byte generatorState;

    /**
     * 生成时间
     */
    @Column(name = "generator_date")
    private Date generatorDate;

    /**
     * 状态说明(一般失败后会有记录)
     */
    @Column(name = "generator_des")
    private String generatorDes;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

}