package cn.smarthse.modules.health.entity.archive;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

/**
 * 
 * 《档案生成结果数据包》
 * 档案生成结果数据包,可做为档案在线预览使用.
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-9-1-上午10:40:35
 */
@Table(name = "archive_files_detail_data")
public class ArchiveFilesDetailData implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 档案结果详情Id
     */
    @Column(name = "archive_files_detail_id")
    private Long archiveFilesDetailId;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 档案Json数据包
     */
    @Column(name = "doc_json")
    private String docJson;

    private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业编号
     *
     * @return cid - 企业编号
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业编号
     *
     * @param cid 企业编号
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取档案结果详情Id
     *
     * @return archive_files_detail_id - 档案结果详情Id
     */
    public Long getArchiveFilesDetailId() {
        return archiveFilesDetailId;
    }

    /**
     * 设置档案结果详情Id
     *
     * @param archiveFilesDetailId 档案结果详情Id
     */
    public void setArchiveFilesDetailId(Long archiveFilesDetailId) {
        this.archiveFilesDetailId = archiveFilesDetailId;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取档案Json数据包
     *
     * @return doc_json - 档案Json数据包
     */
    public String getDocJson() {
        return docJson;
    }

    /**
     * 设置档案Json数据包
     *
     * @param docJson 档案Json数据包
     */
    public void setDocJson(String docJson) {
        this.docJson = docJson == null ? null : docJson.trim();
    }
}