package cn.smarthse.modules.health.entity.archive;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "archive_files_data")
public class ArchiveFilesData implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 档案结果Id
     */
    @Column(name = "archive_files_id")
    private Long archiveFilesId;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 档案Json数据包
     */
    @Column(name = "doc_json")
    private String docJson;

    private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业编号
     *
     * @return cid - 企业编号
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业编号
     *
     * @param cid 企业编号
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取档案结果Id
     *
     * @return archive_files_id - 档案结果Id
     */
    public Long getArchiveFilesId() {
        return archiveFilesId;
    }

    /**
     * 设置档案结果Id
     *
     * @param archiveFilesId 档案结果Id
     */
    public void setArchiveFilesId(Long archiveFilesId) {
        this.archiveFilesId = archiveFilesId;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取档案Json数据包
     *
     * @return doc_json - 档案Json数据包
     */
    public String getDocJson() {
        return docJson;
    }

    /**
     * 设置档案Json数据包
     *
     * @param docJson 档案Json数据包
     */
    public void setDocJson(String docJson) {
        this.docJson = docJson == null ? null : docJson.trim();
    }
}