package cn.smarthse.modules.health.entity.archive;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《档案生成结果表》
 * 档案生成结果,此结果可得到最终的档案文件
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-9-1-上午10:42:16
 */
@Table(name = "archive_files")
public @Data class ArchiveFiles implements Serializable {
	private static final long serialVersionUID = -5195998447543718810L;

	@Id
	@Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 档案生成记录id
     */
    @Column(name = "archive_id")
    private Long archiveId;

    /**
     * 档案任务Id
     */
    @Column(name = "archive_generator_id")
    private Long archiveGeneratorId;

    /**
     * 档案类型
            1-三同时
            2-职业卫生管理档案
            3-职业卫生宣传培训档案
            4-职业病危害因素监测与检测评价档案
            5-用人单位职业健康监护管理档案
            6-劳动者个人职业健康监护档案
     */
    @Column(name = "doc_type")
    private Byte docType;

    /**
     * 档案生成参数值,可用于ids
            1.三同时->参数值:三同时项目ID
            2.职业卫生管理档案>参数值:年份
            3.职业卫生宣传培训档案->参数值:年份
            4-职业病危害因素监测与检测评价档案->参数值:年份
            5-用人单位职业健康监护管理档案->参数:年份
            6-劳动者个人职业健康监护档案->参数:员工Id
            
     */
    @Column(name = "doc_param_value")
    private String docParamValue;

    /**
     * 档案文件Id,多个ids是多个档案的压缩包文件,单个则与detail里的file_id相同
     */
    @Column(name = "doc_file_id")
    private Long docFileId;

    /**
     * 档案生成版本(档案总数+1)
     */
    @Column(name = "doc_version")
    private Integer docVersion;
    
    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    
    /**
     * 生成人
     */
    @Transient
    private Long createBy;
    
    /**
     * 生成人姓名
     */
    @Transient
    private String staffName;

}