package cn.smarthse.modules.health.entity.archive;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《档案自检项组记录表》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-9-1-上午10:36:42
 */
@Table(name = "archive_check_item_group")
public @Data class ArchiveCheckItemGroup implements Serializable {
	private static final long serialVersionUID = -7156138876097776329L;

	@Id
	@Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 档案类型
            1-三同时
            2-职业卫生管理档案
            3-职业卫生宣传培训档案
            4-职业病危害因素监测与检测评价档案
            5-用人单位职业健康监护管理档案
            6-劳动者个人职业健康监护档案
     */
    @Column(name = "doc_type")
    private Byte docType;

    /**
     * 自检项组名
     */
    @Column(name = "doc_check_group_name")
    private String docCheckGroupName;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    
    //================TODO  数据属性定义===================================
    
    /**
     * 警告项
     */
    @Transient
    private int badgeWarning = 0;
}