package cn.smarthse.modules.health.entity.archive;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《档案自检结果详情表》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-9-1-上午10:35:35
 */
@Table(name = "archive_check_detail")
public @Data class ArchiveCheckDetail implements Serializable {
	private static final long serialVersionUID = 8625764997806339967L;

	@Id
	@Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 档案类型
            1-三同时
            2-职业卫生管理档案
            3-职业卫生宣传培训档案
            4-职业病危害因素监测与检测评价档案
            5-用人单位职业健康监护管理档案
            6-劳动者个人职业健康监护档案
     */
    @Column(name = "doc_type")
    private Byte docType;

    /**
     * 档案生成参数值,可用于ids
            1.三同时->参数值:三同时项目ID
            2.职业卫生管理档案>参数值:年份
            3.职业卫生宣传培训档案->参数值:年份
            4-职业病危害因素监测与检测评价档案->参数值:年份
            5-用人单位职业健康监护管理档案->参数:年份
            6-劳动者个人职业健康监护档案->参数:员工Id
            
     */
    @Column(name = "doc_param_value")
    private String docParamValue;

    /**
     * 自检Id
     */
    @Column(name = "doc_check_id")
    private Long docCheckId;

    /**
     * 自检项Id
     */
    @Column(name = "doc_check_item_id")
    private Long docCheckItemId;

    /**
     * 自检项达标值(冗余)(列如需要5条,结果才算正常)
     */
    @Column(name = "doc_check_qualified_count")
    private Integer docCheckQualifiedCount;

    /**
     * 自检项结果值,与doc_check_qualified_count对比之后可显示结果百分比(例如,1/5)
     */
    @Column(name = "doc_check_result_count")
    private Integer docCheckResultCount;

    /**
     * 自检结果(1:合格,0:不合格)
     */
    @Column(name = "doc_check_result_qualified")
    private Boolean docCheckResultQualified;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    
    //========TODO  数据属性===========
    
    /**
     * 检测Item项
     */
    @Transient
    private ArchiveCheckItem checkItem;
}