package cn.smarthse.modules.health.entity.archive;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《档案自检结果调度表》
 * FilesCheckJob进行读取状态判定是否进入自检
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-9-1-上午10:38:13
 */
@Table(name = "archive_check")
public @Data class ArchiveCheck implements Serializable {
	private static final long serialVersionUID = -9096015187812034519L;

	@Id
	@Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 档案主表Id
     * <li>(重要)档案发起检测/重新自检/生成档案时赋予
     * 
     */
    @Column(name = "archive_id")
    private Long archiveId;

    /**
     * 档案编号
     */
    @Column(name = "doc_no")
    private String docNo;
    
    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 档案类型
            1-三同时
            2-职业卫生管理档案
            3-职业卫生宣传培训档案
            4-职业病危害因素监测与检测评价档案
            5-用人单位职业健康监护管理档案
            6-劳动者个人职业健康监护档案
     */
    @Column(name = "doc_type")
    private Byte docType;

    /**
     * 档案生成参数值,可用于ids
            1.三同时->参数值:三同时项目ID
            2.职业卫生管理档案>参数值:年份
            3.职业卫生宣传培训档案->参数值:年份
            4-职业病危害因素监测与检测评价档案->参数值:年份
            5-用人单位职业健康监护管理档案->参数:年份
            6-劳动者个人职业健康监护档案->参数:员工Id
            
     */
    @Column(name = "doc_param_value")
    private String docParamValue;

    /**
     * 自检状态(0-待检测,1-正在自检,2-已完成,3-自检失败)
     * @see cn.smarthse.modules.health.enums.archive.ArchiveCheckState
     */
    @Column(name = "doc_check_state")
    private Byte docCheckState;

    /**
     * 自检完成度,100表示完整,0-99表示不完整
     */
    @Column(name = "doc_check_percent")
    private Integer docCheckPercent;
    
    /**
     * 自检时间
     */
    @Column(name = "doc_check_date")
    private Date docCheckDate;

    /**
     * 自检状态说明(一般失败后会有记录)
     */
    @Column(name = "doc_check_des")
    private String docCheckDes;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

}