package cn.smarthse.modules.health.entity.archive;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《档案任务主表,主要用于隐藏查询》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-9-1-上午10:43:59
 */
public @Data class Archive implements Serializable {
	private static final long serialVersionUID = 1599158411215897770L;

	@Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

	 /**
     * 企业编号
     */
    private Long cid;

    /**
     * 档案编号
     */
    @Column(name = "doc_no")
    private String docNo;
    
    /**
     * 档案标题
     */
    @Column(name = "doc_title")
    private String docTitle;

    /**
     * 档案类型
            1-三同时
            2-职业卫生管理档案
            3-职业卫生宣传培训档案
            4-职业病危害因素监测与检测评价档案
            5-用人单位职业健康监护管理档案
            6-劳动者个人职业健康监护档案
     */
    @Column(name = "doc_type")
    private Byte docType;

    /**
     * 档案生成参数值,可用于ids
            1.三同时->参数值:三同时项目ID
            2.职业卫生管理档案>参数值:年份
            3.职业卫生宣传培训档案->参数值:年份
            4-职业病危害因素监测与检测评价档案->参数值:年份
            5-用人单位职业健康监护管理档案->参数:年份
            6-劳动者个人职业健康监护档案->参数:员工Id
            
     */
    @Column(name = "doc_param_value")
    private String docParamValue;

    /**
     * （冗余）自检状态(0-待检测,1-正在自检,2-已完成,3-自检失败)
     */
    @Column(name = "doc_check_state")
    private Byte docCheckState;

    /**
     * （冗余）自检时间
     */
    @Column(name = "doc_check_date")
    private Date docCheckDate;

    /**
     * （冗余）当前自检Id
     */
    @Column(name = "doc_check_id")
    private Long docCheckId;

    /**
     * （冗余）自检完成度,100表示完整,0-99表示不完整
     */
    @Column(name = "doc_check_percent")
    private Integer docCheckPercent;

    /**
     * 生成状态(0-待生成,1-正在生成,2-已生成3-生成失败?)
     */
    @Column(name = "doc_generator_state")
    private Byte docGeneratorState;

    /**
     * 生成时间
     */
    @Column(name = "doc_generator_date")
    private Date docGeneratorDate;

    /**
     * 档案版本(生成取最大+1)
     * 自检版本，作用不大
     */
    @Deprecated
    @Column(name = "doc_version")
    private Integer docVersion;

    /**
     * 下载次数(冗余)
     */
    @Column(name = "download_count")
    private Integer downloadCount;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;
    
    /**
     * 标题简称
     */
    @Transient
    private String title;
    
    /**
     * 档案主表ID
     */
    @Transient
    private Long archiveId;

    /**
     * 生成档案id
     */
    @Transient
    private Long archiveFilesId;
    
    /**
     * 档案文件
     */
    @Transient
    private Long fileId;
}